/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.security.cli;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.lwapp.commons.cli.AbstractCommand;
import org.lwapp.commons.cli.Terminal;
import org.lwapp.hibernate.persistence.common.UniqueNumberGenerator;
import org.lwapp.hibernate.persistence.util.TransactionHelper;
import org.lwapp.security.db.dao.AuthorizedAppsDao;
import org.lwapp.security.db.dao.AuthorizedOwnerDao;
import org.lwapp.security.db.entity.AuthorizedApps;
import org.lwapp.security.db.entity.AuthorizedOwner;

public class AuthorizationCommand
extends AbstractCommand {
    private final AuthorizedOwnerDao authorizedOwnerDao = new AuthorizedOwnerDao();
    private final AuthorizedAppsDao authorizedAppsDao = new AuthorizedAppsDao();
    private final UniqueNumberGenerator uniqueNumberGenerator = new UniqueNumberGenerator();

    public AuthorizationCommand() {
        super("authorize");
    }

    public void printDescription(Terminal term) {
        term.println("Create new owner and add new applications.");
    }

    public void printUsage(Terminal term) {
        term.println(this.getCommandName() + "\t'-createOwner <ownerName> <uniqueOwnerId>' \n\t'-createApp <uniqueOwnerId> <applicationName>'");
    }

    public void execute(Terminal term, String aArguments) {
        try {
            String response = (String)TransactionHelper.executeInTransaction(() -> {
                if (StringUtils.isBlank((CharSequence)aArguments)) {
                    throw new IllegalArgumentException("Invalid command.");
                }
                String[] args = aArguments.trim().split(" ");
                if (args.length < 1) {
                    throw new IllegalArgumentException("Invalid command.");
                }
                if ("-createOwner".equalsIgnoreCase(args[0])) {
                    if (args.length != 3) {
                        throw new IllegalArgumentException("Invalid arguments.");
                    }
                    String ownerName = args[1];
                    AuthorizedOwner authOwner = new AuthorizedOwner();
                    String ownerId = args[2];
                    authOwner.setOwnerName(ownerName);
                    authOwner.setOwnerId(ownerId);
                    this.authorizedOwnerDao.persist(authOwner);
                    return String.format("\n\nOwner is created succussfully with \n\nownerName:%s \n\nownerId:%s", ownerName, ownerId);
                }
                if ("-createApp".equalsIgnoreCase(args[0])) {
                    if (args.length != 3) {
                        throw new IllegalArgumentException("Invalid arguments.");
                    }
                    String uniqueOwnerId = args[1];
                    AuthorizedOwner authOwner = this.authorizedOwnerDao.findByUniqueOwnerId(uniqueOwnerId);
                    String appName = args[2];
                    AuthorizedApps authApp = new AuthorizedApps();
                    authApp.setApiKey(this.uniqueNumberGenerator.generateUniqueApiKey());
                    authApp.setApiSecret(this.uniqueNumberGenerator.generateUniqueApiSecret());
                    authApp.setApplicationName(appName);
                    authApp.setAuthorizedOwner(authOwner);
                    this.authorizedAppsDao.persist(authApp);
                    return String.format("\n\nApp is created succussfully with authApp \n\nkey:%s \n\nsecret:%s \nownerId:%s", authApp.getApiKey(), authApp.getApiSecret(), authOwner.getOwnerId());
                }
                throw new IllegalArgumentException("Invalid command.");
            });
            term.println(response);
        }
        catch (Exception e) {
            term.println(ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
            this.printUsage(term);
        }
    }
}

