/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.security.manager;

import javax.inject.Inject;
import org.lwapp.hibernate.persistence.common.AbstractEntity;
import org.lwapp.hibernate.persistence.common.UniqueNumberGenerator;
import org.lwapp.security.db.dao.AuthorizedAppsDao;
import org.lwapp.security.db.dao.AuthorizedOwnerDao;
import org.lwapp.security.db.entity.AuthorizedApps;
import org.lwapp.security.db.entity.AuthorizedOwner;
import org.lwapp.security.manager.ApplicationOwnerRegistrationRequest;
import org.lwapp.security.manager.ApplicationOwnerRegistrationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationAuthorizationManager {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationAuthorizationManager.class);
    @Inject
    private AuthorizedOwnerDao authorizedOwnerDao;
    @Inject
    private AuthorizedAppsDao authorizedAppsDao;
    @Inject
    private UniqueNumberGenerator uniqueNumberGenerator;

    public ApplicationOwnerRegistrationResponse generateApiKeys(ApplicationOwnerRegistrationRequest request) {
        String uniqueOwnerId = request.getUniqueOwnerId();
        AuthorizedOwner authOwner = this.authorizedOwnerDao.findByUniqueOwnerId(uniqueOwnerId);
        if (authOwner == null) {
            authOwner = new AuthorizedOwner();
            authOwner.setOwnerName(request.getOwnerName());
            authOwner.setOwnerId(uniqueOwnerId);
            this.authorizedOwnerDao.persist(authOwner);
        }
        AuthorizedApps authApp = this.authorizedAppsDao.findByApplication(request.getApplicationName(), uniqueOwnerId);
        String apiKey = this.uniqueNumberGenerator.generateUniqueApiKey();
        String apiSecret = this.uniqueNumberGenerator.generateUniqueApiSecret();
        if (authApp == null) {
            authApp = new AuthorizedApps();
            authApp.setApiKey(apiKey);
            authApp.setApiSecret(apiSecret);
            authApp.setApplicationName(request.getApplicationName());
            authApp.setAuthorizedOwner(authOwner);
            this.authorizedAppsDao.persist(authApp);
        } else {
            authApp.setApiKey(apiKey);
            authApp.setApiSecret(apiSecret);
            this.authorizedAppsDao.update((AbstractEntity)authApp);
        }
        ApplicationOwnerRegistrationResponse response = new ApplicationOwnerRegistrationResponse.Builder().apiKey(authApp.getApiKey()).apiSecret(authApp.getApiSecret()).applicationName(request.getApplicationName()).uniqueOwnerId(request.getUniqueOwnerId()).build();
        LOG.info("Application owner api keys are recreated succussfully with authApp \n\napiKey:{} \n\napiSecret:{} \nownerId:{} \napplicationName:{}", new Object[]{authApp.getApiKey(), authApp.getApiSecret(), request.getUniqueOwnerId(), request.getApplicationName()});
        return response;
    }
}

