/*
 * Decompiled with CFR 0.152.
 */
package org.lyranthe.prometheus.client.registry;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import org.lyranthe.prometheus.client.registry.Bucket;
import org.lyranthe.prometheus.client.registry.CounterMetric;
import org.lyranthe.prometheus.client.registry.GaugeMetric;
import org.lyranthe.prometheus.client.registry.HistogramMetric;
import org.lyranthe.prometheus.client.registry.LabelPair;
import org.lyranthe.prometheus.client.registry.Metric;
import org.lyranthe.prometheus.client.registry.RegistryFormat;
import org.lyranthe.prometheus.client.registry.RegistryMetrics;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TextFormat$
implements RegistryFormat {
    public static TextFormat$ MODULE$;
    private final String contentType;

    static {
        new TextFormat$();
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    public String prometheusDoubleFormat(double d) {
        return d == Double.POSITIVE_INFINITY ? "+Inf" : (d == Double.NEGATIVE_INFINITY ? "-Inf" : (Predef$.MODULE$.double2Double(d).isNaN() ? "NaN" : ((Object)BoxesRunTime.boxToDouble((double)d)).toString()));
    }

    @Override
    public byte[] output(Function0<Iterator<RegistryMetrics>> values) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        ((Iterator)values.apply()).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            TextFormat$.$anonfun$output$2(outputStream, metric);
            return BoxedUnit.UNIT;
        });
        return outputStream.toByteArray();
    }

    private static final String labelsToString$1(List labelPairs) {
        return labelPairs.isEmpty() ? "" : ((TraversableOnce)labelPairs.map((Function1 & Serializable & scala.Serializable)pair -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pair.name(), pair.escapedValue()})), List$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
    }

    public static final /* synthetic */ void $anonfun$output$2(ByteArrayOutputStream outputStream$1, RegistryMetrics metric) {
        StringBuilder sb = new StringBuilder();
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# HELP ", " ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metric.name(), metric.escapedHelp()})));
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# TYPE ", " ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metric.name(), metric.metricType().toString()})));
        metric.metrics().foreach((Function1 & Serializable & scala.Serializable)rm -> {
            StringBuilder stringBuilder;
            Metric metric = rm;
            if (metric instanceof GaugeMetric) {
                GaugeMetric gaugeMetric = (GaugeMetric)metric;
                List<LabelPair> labels = gaugeMetric.labels();
                double value = gaugeMetric.value();
                stringBuilder = sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", " ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metric.name(), TextFormat$.labelsToString$1(labels), BoxesRunTime.boxToDouble((double)value)})));
            } else if (metric instanceof CounterMetric) {
                CounterMetric counterMetric = (CounterMetric)metric;
                List<LabelPair> labels = counterMetric.labels();
                double value = counterMetric.value();
                stringBuilder = sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", " ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metric.name(), TextFormat$.labelsToString$1(labels), BoxesRunTime.boxToDouble((double)value)})));
            } else if (metric instanceof HistogramMetric) {
                HistogramMetric histogramMetric = (HistogramMetric)metric;
                List<LabelPair> labels = histogramMetric.labels();
                long sampleCount = histogramMetric.sampleCount();
                double sampleSum = histogramMetric.sampleSum();
                Bucket[] buckets = histogramMetric.buckets();
                String labelStr = TextFormat$.labelsToString$1(labels);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])buckets)).foreach((Function1 & Serializable & scala.Serializable)bucket -> {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = metric.name();
                    LabelPair labelPair = new LabelPair("le", MODULE$.prometheusDoubleFormat(bucket.upperBound()));
                    objectArray[1] = TextFormat$.labelsToString$1(labels.$colon$colon((Object)labelPair));
                    objectArray[2] = BoxesRunTime.boxToLong((long)bucket.cumulativeCount());
                    return sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_bucket", " ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
                });
                sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_count", " ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metric.name(), labelStr, BoxesRunTime.boxToLong((long)sampleCount)})));
                stringBuilder = sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_sum", " ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metric.name(), labelStr, BoxesRunTime.boxToDouble((double)sampleSum)})));
            } else {
                throw new MatchError((Object)metric);
            }
            return stringBuilder;
        });
        outputStream$1.write(sb.toString().getBytes());
    }

    private TextFormat$() {
        MODULE$ = this;
        this.contentType = "text/plain; version=0.0.4";
    }
}

