// auto-generated by sbt-boilerplate
package org.lyranthe.prometheus.client.histogram

import org.lyranthe.prometheus.client._
import org.lyranthe.prometheus.client.internal._
import org.lyranthe.prometheus.client.registry._

final case class Histogram1 private[client] (name: MetricName,
                                             help: String,
                                             labels: List[LabelName],
                                             bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders =
    new BucketedAdders[Tuple1[String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String): LabelledHistogram =
    new LabelledHistogram(name, labels, adders(Tuple1(labelValue1)))

  def remove(labelValue1: String): Unit =
    adders.remove(Tuple1(labelValue1))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram2 private[client] (name: MetricName,
                                             help: String,
                                             labels: List[LabelName],
                                             bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders =
    new BucketedAdders[Tuple2[String, String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String): LabelledHistogram =
    new LabelledHistogram(name,
                          labels,
                          adders(Tuple2(labelValue1, labelValue2)))

  def remove(labelValue1: String, labelValue2: String): Unit =
    adders.remove(Tuple2(labelValue1, labelValue2))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram3 private[client] (name: MetricName,
                                             help: String,
                                             labels: List[LabelName],
                                             bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders =
    new BucketedAdders[Tuple3[String, String, String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(Tuple3(labelValue1, labelValue2, labelValue3)))

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String): Unit =
    adders.remove(Tuple3(labelValue1, labelValue2, labelValue3))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram4 private[client] (name: MetricName,
                                             help: String,
                                             labels: List[LabelName],
                                             bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders =
    new BucketedAdders[Tuple4[String, String, String, String]](
      bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(Tuple4(labelValue1, labelValue2, labelValue3, labelValue4)))

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String): Unit =
    adders.remove(Tuple4(labelValue1, labelValue2, labelValue3, labelValue4))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram5 private[client] (name: MetricName,
                                             help: String,
                                             labels: List[LabelName],
                                             bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders =
    new BucketedAdders[Tuple5[String, String, String, String, String]](
      bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String): LabelledHistogram =
    new LabelledHistogram(name,
                          labels,
                          adders(
                            Tuple5(labelValue1,
                                   labelValue2,
                                   labelValue3,
                                   labelValue4,
                                   labelValue5)))

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String): Unit =
    adders.remove(
      Tuple5(labelValue1, labelValue2, labelValue3, labelValue4, labelValue5))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram6 private[client] (name: MetricName,
                                             help: String,
                                             labels: List[LabelName],
                                             bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders =
    new BucketedAdders[Tuple6[String, String, String, String, String, String]](
      bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String): LabelledHistogram =
    new LabelledHistogram(name,
                          labels,
                          adders(
                            Tuple6(labelValue1,
                                   labelValue2,
                                   labelValue3,
                                   labelValue4,
                                   labelValue5,
                                   labelValue6)))

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String): Unit =
    adders.remove(
      Tuple6(labelValue1,
             labelValue2,
             labelValue3,
             labelValue4,
             labelValue5,
             labelValue6))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram7 private[client] (name: MetricName,
                                             help: String,
                                             labels: List[LabelName],
                                             bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple7[String, String, String, String, String, String, String]](
    bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String): LabelledHistogram =
    new LabelledHistogram(name,
                          labels,
                          adders(
                            Tuple7(labelValue1,
                                   labelValue2,
                                   labelValue3,
                                   labelValue4,
                                   labelValue5,
                                   labelValue6,
                                   labelValue7)))

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String): Unit =
    adders.remove(
      Tuple7(labelValue1,
             labelValue2,
             labelValue3,
             labelValue4,
             labelValue5,
             labelValue6,
             labelValue7))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram8 private[client] (name: MetricName,
                                             help: String,
                                             labels: List[LabelName],
                                             bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple8[String, String, String, String, String, String, String, String]](
    bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String): LabelledHistogram =
    new LabelledHistogram(name,
                          labels,
                          adders(
                            Tuple8(labelValue1,
                                   labelValue2,
                                   labelValue3,
                                   labelValue4,
                                   labelValue5,
                                   labelValue6,
                                   labelValue7,
                                   labelValue8)))

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String): Unit =
    adders.remove(
      Tuple8(labelValue1,
             labelValue2,
             labelValue3,
             labelValue4,
             labelValue5,
             labelValue6,
             labelValue7,
             labelValue8))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram9 private[client] (name: MetricName,
                                             help: String,
                                             labels: List[LabelName],
                                             bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple9[String,
           String,
           String,
           String,
           String,
           String,
           String,
           String,
           String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String): LabelledHistogram =
    new LabelledHistogram(name,
                          labels,
                          adders(
                            Tuple9(labelValue1,
                                   labelValue2,
                                   labelValue3,
                                   labelValue4,
                                   labelValue5,
                                   labelValue6,
                                   labelValue7,
                                   labelValue8,
                                   labelValue9)))

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String): Unit =
    adders.remove(
      Tuple9(labelValue1,
             labelValue2,
             labelValue3,
             labelValue4,
             labelValue5,
             labelValue6,
             labelValue7,
             labelValue8,
             labelValue9))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram10 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple10[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String): LabelledHistogram =
    new LabelledHistogram(name,
                          labels,
                          adders(
                            Tuple10(labelValue1,
                                    labelValue2,
                                    labelValue3,
                                    labelValue4,
                                    labelValue5,
                                    labelValue6,
                                    labelValue7,
                                    labelValue8,
                                    labelValue9,
                                    labelValue10)))

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String): Unit =
    adders.remove(
      Tuple10(labelValue1,
              labelValue2,
              labelValue3,
              labelValue4,
              labelValue5,
              labelValue6,
              labelValue7,
              labelValue8,
              labelValue9,
              labelValue10))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram11 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple11[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String,
                  labelValue11: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(
        Tuple11(labelValue1,
                labelValue2,
                labelValue3,
                labelValue4,
                labelValue5,
                labelValue6,
                labelValue7,
                labelValue8,
                labelValue9,
                labelValue10,
                labelValue11))
    )

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String,
             labelValue11: String): Unit =
    adders.remove(
      Tuple11(labelValue1,
              labelValue2,
              labelValue3,
              labelValue4,
              labelValue5,
              labelValue6,
              labelValue7,
              labelValue8,
              labelValue9,
              labelValue10,
              labelValue11))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram12 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple12[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String,
                  labelValue11: String,
                  labelValue12: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(
        Tuple12(labelValue1,
                labelValue2,
                labelValue3,
                labelValue4,
                labelValue5,
                labelValue6,
                labelValue7,
                labelValue8,
                labelValue9,
                labelValue10,
                labelValue11,
                labelValue12))
    )

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String,
             labelValue11: String,
             labelValue12: String): Unit =
    adders.remove(
      Tuple12(labelValue1,
              labelValue2,
              labelValue3,
              labelValue4,
              labelValue5,
              labelValue6,
              labelValue7,
              labelValue8,
              labelValue9,
              labelValue10,
              labelValue11,
              labelValue12))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram13 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple13[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String,
                  labelValue11: String,
                  labelValue12: String,
                  labelValue13: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(
        Tuple13(
          labelValue1,
          labelValue2,
          labelValue3,
          labelValue4,
          labelValue5,
          labelValue6,
          labelValue7,
          labelValue8,
          labelValue9,
          labelValue10,
          labelValue11,
          labelValue12,
          labelValue13
        ))
    )

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String,
             labelValue11: String,
             labelValue12: String,
             labelValue13: String): Unit =
    adders.remove(
      Tuple13(
        labelValue1,
        labelValue2,
        labelValue3,
        labelValue4,
        labelValue5,
        labelValue6,
        labelValue7,
        labelValue8,
        labelValue9,
        labelValue10,
        labelValue11,
        labelValue12,
        labelValue13
      ))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram14 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple14[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String,
                  labelValue11: String,
                  labelValue12: String,
                  labelValue13: String,
                  labelValue14: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(
        Tuple14(
          labelValue1,
          labelValue2,
          labelValue3,
          labelValue4,
          labelValue5,
          labelValue6,
          labelValue7,
          labelValue8,
          labelValue9,
          labelValue10,
          labelValue11,
          labelValue12,
          labelValue13,
          labelValue14
        ))
    )

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String,
             labelValue11: String,
             labelValue12: String,
             labelValue13: String,
             labelValue14: String): Unit =
    adders.remove(
      Tuple14(
        labelValue1,
        labelValue2,
        labelValue3,
        labelValue4,
        labelValue5,
        labelValue6,
        labelValue7,
        labelValue8,
        labelValue9,
        labelValue10,
        labelValue11,
        labelValue12,
        labelValue13,
        labelValue14
      ))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram15 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple15[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String,
                  labelValue11: String,
                  labelValue12: String,
                  labelValue13: String,
                  labelValue14: String,
                  labelValue15: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(
        Tuple15(
          labelValue1,
          labelValue2,
          labelValue3,
          labelValue4,
          labelValue5,
          labelValue6,
          labelValue7,
          labelValue8,
          labelValue9,
          labelValue10,
          labelValue11,
          labelValue12,
          labelValue13,
          labelValue14,
          labelValue15
        ))
    )

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String,
             labelValue11: String,
             labelValue12: String,
             labelValue13: String,
             labelValue14: String,
             labelValue15: String): Unit =
    adders.remove(
      Tuple15(
        labelValue1,
        labelValue2,
        labelValue3,
        labelValue4,
        labelValue5,
        labelValue6,
        labelValue7,
        labelValue8,
        labelValue9,
        labelValue10,
        labelValue11,
        labelValue12,
        labelValue13,
        labelValue14,
        labelValue15
      ))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram16 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple16[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String,
                  labelValue11: String,
                  labelValue12: String,
                  labelValue13: String,
                  labelValue14: String,
                  labelValue15: String,
                  labelValue16: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(
        Tuple16(
          labelValue1,
          labelValue2,
          labelValue3,
          labelValue4,
          labelValue5,
          labelValue6,
          labelValue7,
          labelValue8,
          labelValue9,
          labelValue10,
          labelValue11,
          labelValue12,
          labelValue13,
          labelValue14,
          labelValue15,
          labelValue16
        ))
    )

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String,
             labelValue11: String,
             labelValue12: String,
             labelValue13: String,
             labelValue14: String,
             labelValue15: String,
             labelValue16: String): Unit =
    adders.remove(
      Tuple16(
        labelValue1,
        labelValue2,
        labelValue3,
        labelValue4,
        labelValue5,
        labelValue6,
        labelValue7,
        labelValue8,
        labelValue9,
        labelValue10,
        labelValue11,
        labelValue12,
        labelValue13,
        labelValue14,
        labelValue15,
        labelValue16
      ))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram17 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple17[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String,
                  labelValue11: String,
                  labelValue12: String,
                  labelValue13: String,
                  labelValue14: String,
                  labelValue15: String,
                  labelValue16: String,
                  labelValue17: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(
        Tuple17(
          labelValue1,
          labelValue2,
          labelValue3,
          labelValue4,
          labelValue5,
          labelValue6,
          labelValue7,
          labelValue8,
          labelValue9,
          labelValue10,
          labelValue11,
          labelValue12,
          labelValue13,
          labelValue14,
          labelValue15,
          labelValue16,
          labelValue17
        ))
    )

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String,
             labelValue11: String,
             labelValue12: String,
             labelValue13: String,
             labelValue14: String,
             labelValue15: String,
             labelValue16: String,
             labelValue17: String): Unit =
    adders.remove(
      Tuple17(
        labelValue1,
        labelValue2,
        labelValue3,
        labelValue4,
        labelValue5,
        labelValue6,
        labelValue7,
        labelValue8,
        labelValue9,
        labelValue10,
        labelValue11,
        labelValue12,
        labelValue13,
        labelValue14,
        labelValue15,
        labelValue16,
        labelValue17
      ))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram18 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple18[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String,
                  labelValue11: String,
                  labelValue12: String,
                  labelValue13: String,
                  labelValue14: String,
                  labelValue15: String,
                  labelValue16: String,
                  labelValue17: String,
                  labelValue18: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(
        Tuple18(
          labelValue1,
          labelValue2,
          labelValue3,
          labelValue4,
          labelValue5,
          labelValue6,
          labelValue7,
          labelValue8,
          labelValue9,
          labelValue10,
          labelValue11,
          labelValue12,
          labelValue13,
          labelValue14,
          labelValue15,
          labelValue16,
          labelValue17,
          labelValue18
        ))
    )

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String,
             labelValue11: String,
             labelValue12: String,
             labelValue13: String,
             labelValue14: String,
             labelValue15: String,
             labelValue16: String,
             labelValue17: String,
             labelValue18: String): Unit =
    adders.remove(
      Tuple18(
        labelValue1,
        labelValue2,
        labelValue3,
        labelValue4,
        labelValue5,
        labelValue6,
        labelValue7,
        labelValue8,
        labelValue9,
        labelValue10,
        labelValue11,
        labelValue12,
        labelValue13,
        labelValue14,
        labelValue15,
        labelValue16,
        labelValue17,
        labelValue18
      ))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram19 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple19[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String,
                  labelValue11: String,
                  labelValue12: String,
                  labelValue13: String,
                  labelValue14: String,
                  labelValue15: String,
                  labelValue16: String,
                  labelValue17: String,
                  labelValue18: String,
                  labelValue19: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(
        Tuple19(
          labelValue1,
          labelValue2,
          labelValue3,
          labelValue4,
          labelValue5,
          labelValue6,
          labelValue7,
          labelValue8,
          labelValue9,
          labelValue10,
          labelValue11,
          labelValue12,
          labelValue13,
          labelValue14,
          labelValue15,
          labelValue16,
          labelValue17,
          labelValue18,
          labelValue19
        ))
    )

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String,
             labelValue11: String,
             labelValue12: String,
             labelValue13: String,
             labelValue14: String,
             labelValue15: String,
             labelValue16: String,
             labelValue17: String,
             labelValue18: String,
             labelValue19: String): Unit =
    adders.remove(
      Tuple19(
        labelValue1,
        labelValue2,
        labelValue3,
        labelValue4,
        labelValue5,
        labelValue6,
        labelValue7,
        labelValue8,
        labelValue9,
        labelValue10,
        labelValue11,
        labelValue12,
        labelValue13,
        labelValue14,
        labelValue15,
        labelValue16,
        labelValue17,
        labelValue18,
        labelValue19
      ))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram20 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple20[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String,
                  labelValue11: String,
                  labelValue12: String,
                  labelValue13: String,
                  labelValue14: String,
                  labelValue15: String,
                  labelValue16: String,
                  labelValue17: String,
                  labelValue18: String,
                  labelValue19: String,
                  labelValue20: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(
        Tuple20(
          labelValue1,
          labelValue2,
          labelValue3,
          labelValue4,
          labelValue5,
          labelValue6,
          labelValue7,
          labelValue8,
          labelValue9,
          labelValue10,
          labelValue11,
          labelValue12,
          labelValue13,
          labelValue14,
          labelValue15,
          labelValue16,
          labelValue17,
          labelValue18,
          labelValue19,
          labelValue20
        ))
    )

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String,
             labelValue11: String,
             labelValue12: String,
             labelValue13: String,
             labelValue14: String,
             labelValue15: String,
             labelValue16: String,
             labelValue17: String,
             labelValue18: String,
             labelValue19: String,
             labelValue20: String): Unit =
    adders.remove(
      Tuple20(
        labelValue1,
        labelValue2,
        labelValue3,
        labelValue4,
        labelValue5,
        labelValue6,
        labelValue7,
        labelValue8,
        labelValue9,
        labelValue10,
        labelValue11,
        labelValue12,
        labelValue13,
        labelValue14,
        labelValue15,
        labelValue16,
        labelValue17,
        labelValue18,
        labelValue19,
        labelValue20
      ))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram21 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple21[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String,
                  labelValue11: String,
                  labelValue12: String,
                  labelValue13: String,
                  labelValue14: String,
                  labelValue15: String,
                  labelValue16: String,
                  labelValue17: String,
                  labelValue18: String,
                  labelValue19: String,
                  labelValue20: String,
                  labelValue21: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(
        Tuple21(
          labelValue1,
          labelValue2,
          labelValue3,
          labelValue4,
          labelValue5,
          labelValue6,
          labelValue7,
          labelValue8,
          labelValue9,
          labelValue10,
          labelValue11,
          labelValue12,
          labelValue13,
          labelValue14,
          labelValue15,
          labelValue16,
          labelValue17,
          labelValue18,
          labelValue19,
          labelValue20,
          labelValue21
        ))
    )

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String,
             labelValue11: String,
             labelValue12: String,
             labelValue13: String,
             labelValue14: String,
             labelValue15: String,
             labelValue16: String,
             labelValue17: String,
             labelValue18: String,
             labelValue19: String,
             labelValue20: String,
             labelValue21: String): Unit =
    adders.remove(
      Tuple21(
        labelValue1,
        labelValue2,
        labelValue3,
        labelValue4,
        labelValue5,
        labelValue6,
        labelValue7,
        labelValue8,
        labelValue9,
        labelValue10,
        labelValue11,
        labelValue12,
        labelValue13,
        labelValue14,
        labelValue15,
        labelValue16,
        labelValue17,
        labelValue18,
        labelValue19,
        labelValue20,
        labelValue21
      ))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}

final case class Histogram22 private[client] (name: MetricName,
                                              help: String,
                                              labels: List[LabelName],
                                              bucketValues: List[Double])
    extends MetricFamily {
  private[client] val adders = new BucketedAdders[
    Tuple22[String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String,
            String]](bucketValues.toArray)

  override final val metricType = MetricType.Histogram

  override final val escapedHelp =
    help.replace("\\", "\\\\").replace("\n", "\\n")

  def labelValues(labelValue1: String,
                  labelValue2: String,
                  labelValue3: String,
                  labelValue4: String,
                  labelValue5: String,
                  labelValue6: String,
                  labelValue7: String,
                  labelValue8: String,
                  labelValue9: String,
                  labelValue10: String,
                  labelValue11: String,
                  labelValue12: String,
                  labelValue13: String,
                  labelValue14: String,
                  labelValue15: String,
                  labelValue16: String,
                  labelValue17: String,
                  labelValue18: String,
                  labelValue19: String,
                  labelValue20: String,
                  labelValue21: String,
                  labelValue22: String): LabelledHistogram =
    new LabelledHistogram(
      name,
      labels,
      adders(
        Tuple22(
          labelValue1,
          labelValue2,
          labelValue3,
          labelValue4,
          labelValue5,
          labelValue6,
          labelValue7,
          labelValue8,
          labelValue9,
          labelValue10,
          labelValue11,
          labelValue12,
          labelValue13,
          labelValue14,
          labelValue15,
          labelValue16,
          labelValue17,
          labelValue18,
          labelValue19,
          labelValue20,
          labelValue21,
          labelValue22
        ))
    )

  def remove(labelValue1: String,
             labelValue2: String,
             labelValue3: String,
             labelValue4: String,
             labelValue5: String,
             labelValue6: String,
             labelValue7: String,
             labelValue8: String,
             labelValue9: String,
             labelValue10: String,
             labelValue11: String,
             labelValue12: String,
             labelValue13: String,
             labelValue14: String,
             labelValue15: String,
             labelValue16: String,
             labelValue17: String,
             labelValue18: String,
             labelValue19: String,
             labelValue20: String,
             labelValue21: String,
             labelValue22: String): Unit =
    adders.remove(
      Tuple22(
        labelValue1,
        labelValue2,
        labelValue3,
        labelValue4,
        labelValue5,
        labelValue6,
        labelValue7,
        labelValue8,
        labelValue9,
        labelValue10,
        labelValue11,
        labelValue12,
        labelValue13,
        labelValue14,
        labelValue15,
        labelValue16,
        labelValue17,
        labelValue18,
        labelValue19,
        labelValue20,
        labelValue21,
        labelValue22
      ))

  def clear(): Unit =
    adders.clear()

  override def collect(): List[HistogramMetric] =
    adders.getAll.map({
      case (labelValues, value) =>
        val labelAndValues = labels
          .zip(
            labelValues.productIterator
              .asInstanceOf[Iterator[String]]
              .toIterable)
          .map((LabelPair.apply _).tupled)
        HistogramMetric(labelAndValues,
                        value._2.last._2,
                        value._1,
                        value._2.map {
                          case (bucket, adder) => Bucket(adder, bucket)
                        })
    })
}
