/*
 * Decompiled with CFR 0.152.
 */
package org.lyranthe.prometheus.client.registry;

import com.google.protobuf.CodedOutputStream;
import io.prometheus.client.Metrics;
import java.io.Serializable;
import org.lyranthe.prometheus.client.LabelName;
import org.lyranthe.prometheus.client.MetricType;
import org.lyranthe.prometheus.client.registry.Bucket;
import org.lyranthe.prometheus.client.registry.CounterMetric;
import org.lyranthe.prometheus.client.registry.GaugeMetric;
import org.lyranthe.prometheus.client.registry.HistogramMetric;
import org.lyranthe.prometheus.client.registry.Metric;
import org.lyranthe.prometheus.client.registry.RegistryFormat;
import org.lyranthe.prometheus.client.registry.RegistryMetrics;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class ProtoFormat$
implements RegistryFormat {
    public static ProtoFormat$ MODULE$;
    private final String contentType;

    static {
        new ProtoFormat$();
    }

    public String contentType() {
        return this.contentType;
    }

    public List<Metrics.LabelPair> labelPairs(List<Tuple2<String, String>> labels) {
        return (List)labels.map((Function1 & Serializable & scala.Serializable)lp -> Metrics.LabelPair.newBuilder().setName(((LabelName)lp._1()).name()).setValue((String)lp._2()).build(), List$.MODULE$.canBuildFrom());
    }

    public Metrics.Bucket convertBucket(Bucket bucket) {
        return Metrics.Bucket.newBuilder().setCumulativeCount(bucket.cumulativeCount()).setUpperBound(bucket.upperBound()).build();
    }

    public Metrics.Metric convertMetric(Metric metric) {
        Metrics.Metric.Builder builder;
        Metrics.Metric.Builder newMetric = Metrics.Metric.newBuilder();
        newMetric.addAllLabel((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(this.labelPairs((List<Tuple2<String, String>>)metric.labels())).asJava());
        Metric metric2 = metric;
        if (metric2 instanceof GaugeMetric) {
            GaugeMetric gaugeMetric = (GaugeMetric)metric2;
            double value = gaugeMetric.value();
            builder = newMetric.setGauge(Metrics.Gauge.newBuilder().setValue(value));
        } else if (metric2 instanceof CounterMetric) {
            CounterMetric counterMetric = (CounterMetric)metric2;
            double value = counterMetric.value();
            builder = newMetric.setCounter(Metrics.Counter.newBuilder().setValue(value));
        } else if (metric2 instanceof HistogramMetric) {
            HistogramMetric histogramMetric = (HistogramMetric)metric2;
            long sampleCount = histogramMetric.sampleCount();
            double sampleSum = histogramMetric.sampleSum();
            Bucket[] buckets = histogramMetric.buckets();
            builder = newMetric.setHistogram(Metrics.Histogram.newBuilder().setSampleCount(sampleCount).setSampleSum(sampleSum).addAllBucket((Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])buckets)).map((Function1 & Serializable & scala.Serializable)bucket -> this.convertBucket((Bucket)bucket), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Metrics.Bucket.class))))).toIterable()).asJava()));
        } else {
            throw new MatchError((Object)metric2);
        }
        return newMetric.build();
    }

    public Metrics.MetricType convertMetricType(MetricType metricType) {
        Metrics.MetricType metricType2;
        MetricType metricType3 = metricType;
        if (MetricType.Counter$.MODULE$.equals(metricType3)) {
            metricType2 = Metrics.MetricType.COUNTER;
        } else if (MetricType.Gauge$.MODULE$.equals(metricType3)) {
            metricType2 = Metrics.MetricType.GAUGE;
        } else if (MetricType.Histogram$.MODULE$.equals(metricType3)) {
            metricType2 = Metrics.MetricType.HISTOGRAM;
        } else {
            throw new MatchError((Object)metricType3);
        }
        return metricType2;
    }

    public Iterator<byte[]> output(Function0<Iterator<RegistryMetrics>> values) {
        return ((Iterator)values.apply()).map((Function1 & Serializable & scala.Serializable)metric2 -> {
            Metrics.MetricFamily proto = Metrics.MetricFamily.newBuilder().setName(metric2.name()).setHelp(metric2.help()).setType(this.convertMetricType(metric2.metricType())).addAllMetric((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)metric2.metrics().map((Function1 & Serializable & scala.Serializable)metric -> this.convertMetric((Metric)metric), List$.MODULE$.canBuildFrom())).asJava()).build();
            int serializedSize = proto.getSerializedSize();
            int sizeTagSize = CodedOutputStream.computeUInt32SizeNoTag((int)serializedSize);
            byte[] arr = new byte[sizeTagSize + serializedSize];
            CodedOutputStream outputStream = CodedOutputStream.newInstance((byte[])arr);
            outputStream.writeRawVarint32(serializedSize);
            proto.writeTo(outputStream);
            outputStream.flush();
            return arr;
        });
    }

    private ProtoFormat$() {
        MODULE$ = this;
        this.contentType = "application/vnd.google.protobuf; proto=io.prometheus.client.MetricFamily; encoding=delimited";
    }
}

