package org.magictest.eclipse;

/**
 * Info about selection in Eclipse UI.
 *
 * @author Thomas Mauch
 * @version $Id$
 */
public class SelectInfo {
	/** project name (never null) */
	public String projectName;
	/** source folder (if set all other entries except projectName are ignored) */
	public String sourceFolder;
	/** package name (null if className is set) */
	public String packageName;
	/** class name (including package, null if packageName is set) */
	public String className;
	/** method name (may be null if a whole class should be run) */
	public String methodName;

	@Override
	public String toString() {
		if (methodName == null) {
			return projectName + ":" + className;
		} else {
			return projectName + ":" + className + ":" + methodName;
		}
	}
}
