package org.magictest.testng.eclipse;

import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.core.strings.escape.StringListEscaper;

/**
 * Tools for working with VMRunner.
 * 
 * @author Thomas Mauch
 * @version $Id$
 */
public class VMRunnerTools {

	public static String toString(VMRunnerConfiguration config) {
		StringBuilder sb = new StringBuilder("VMRunnerConfiguration:");
		sb.append("\n  Classpath: " + print(config.getClassPath()));
		sb.append("\n  VMArgs:    " + print(config.getVMArguments()));
		sb.append("\n  Class:     " + config.getClassToLaunch());
		sb.append("\n  Args:      " + print(config.getProgramArguments()));
		sb.append("\n");
		return sb.toString();
	}

	static String print(String[] strings) {
		IList<String> strs = GapList.create(strings);
		return StringListEscaper.JavaSimpleListEscaper().encode(strs);
	}

}
