package org.magictest.testng.eclipse.buildpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.magictest.testng.eclipse.MagicTestPlugin;
import org.magictest.testng.eclipse.TestNGPluginConstants;
import org.osgi.framework.Bundle;


/**
 * This class/interface 
 */
public class MagicTestHomeInitializer extends ClasspathVariableInitializer {

  /**
   * @see org.eclipse.jdt.core.ClasspathVariableInitializer#initialize(java.lang.String)
   */
  public void initialize(String variable) {
    try {
        Bundle bundle= MagicTestPlugin.getDefault().getBundle(MagicTestPlugin.PLUGIN_ID);
        if (bundle == null) {
          clearVariable();
          return;
        }
        
        URL local= null;
        try {
            local= FileLocator.toFileURL(bundle.getEntry("/")); //$NON-NLS-1$
        } 
        catch (IOException e) {
          clearVariable();
          return;
        }
        IPath location= Path.fromOSString(new File(local.getPath()).getAbsolutePath());
        if (null != location) {
          JavaCore.setClasspathVariable(TestNGPluginConstants.MAGICTEST_HOME, location, null);
        }
        else {
        }
    }
    catch(JavaModelException jmex) {
      clearVariable();
    }
  }

  private void clearVariable() {
    JavaCore.removeClasspathVariable(TestNGPluginConstants.MAGICTEST_HOME, null);
  }
}
