package org.magictest.testng.eclipse.ui.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.magictest.MagicTestTools;
import org.magictest.TestRunner;
import org.magictest.testng.eclipse.MagicTestPlugin;
import org.magictest.testng.eclipse.TestNGPluginConstants;
import org.testng.TestNG;

/**
 * Class used to initialize default preference values.
 */
public class PreferenceInitializer extends AbstractPreferenceInitializer {

	@Override
	public void initializeDefaultPreferences() {
		IPreferenceStore store = MagicTestPlugin.getDefault().getPreferenceStore();
		store.setDefault(TestNGPluginConstants.S_TESTNG_OUTDIR, TestNG.DEFAULT_OUTPUTDIR);
		store.setDefault(TestNGPluginConstants.S_MAGICTEST_OUTDIR, TestRunner.MAGICTEST_DIR);
	}

}
