package org.magictest.testng.eclipse.util;

import java.io.File;
import java.util.HashMap;
import java.util.Random;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.magictest.TestRunner;
import org.magictest.eclipse.tools.JdtTools;
import org.magictest.ext.org.magicwerk.brownies.core.files.PathTools;
import org.magictest.testng.eclipse.TestNGPluginConstants;
import org.magictest.testng.eclipse.properties.MagicTestProperties;
import org.testng.TestNG;

/**
 * Utility methods to store and retrieve data in the preference store.
 *
 * @author Cedric Beust <cedric@beust.com>
 */
public class PreferenceStoreUtil {
	private IPreferenceStore m_storage;

	private HashMap<String, MagicTestProperties> propertiesMap = new HashMap<String, MagicTestProperties>();

	public PreferenceStoreUtil(IPreferenceStore storage) {
		m_storage = storage;
		m_storage.addPropertyChangeListener(new IPropertyChangeListener() {
			@Override
			public void propertyChange(PropertyChangeEvent event) {
				propertiesMap.put(null, null);
			}
		});
	}

	//	public void storeTestNgOutDir(String projectName, String dir) {
	//		m_storage.setValue(projectName + TestNGPluginConstants.S_TESTNG_OUTDIR,	dir);
	//	}
	//
	//	public void storeMagicTestOutDir(String projectName, String dir) {
	//		m_storage.setValue(projectName + TestNGPluginConstants.S_MAGICTEST_OUTDIR, dir);
	//	}
	//
	//	public void storeUseProjectJar(String projectName, boolean selection) {
	//		m_storage.setValue(projectName + TestNGPluginConstants.S_USEPROJECTJAR,	selection);
	//	}

	public void storeDisabledListeners(String projectName, boolean selection) {
		m_storage.setValue(projectName + ".disabledListeners", selection);
	}

	public void storeXmlTemplateFile(String projectName, String xmlFile) {
		m_storage.setValue(projectName
				+ TestNGPluginConstants.S_XML_TEMPLATE_FILE, xmlFile);
	}

	public File getTemporaryDirectory() {
		Random r = new Random(System.currentTimeMillis());
		File result = new File(System.getProperty("java.io.tmpdir")
				+ File.separatorChar + "testng-eclipse-" + r.nextInt());

		return result;
	}

	public String getXmlTemplateFile(String projectName, boolean projectOnly) {
		if (projectOnly) {
			return m_storage.getString(projectName
					+ TestNGPluginConstants.S_XML_TEMPLATE_FILE);
		} else {
			return "";
		}
	}

	public boolean isTestNgOutDirAbs(IJavaProject project) {
		return false;

		// TODO
		// currently only project relative directories are supported
		// if we allow absolute paths, we must be able to determine
		// from a path to which project it belongs or we must peek
		// into the file to determine the project (the project is
		// needed to run a test from report's link)
		// if we add support for absolute paths, all getPath methods
		// below must use PathTools.changeDir()

		//		final String projectName = project.getElementName();
		//		final String outdir = getTestNgOutDir(projectName, false);
		//		FilePath fp = PathTools.analyzePath(outdir);
		//		return fp.getType() != FilePath.Type.RELATIVE;
	}

	public IPath getTestNgOutPath(IJavaProject jprj) {
		MagicTestProperties props = getProjectProperties(jprj);
		final String outdir = props.getOutputDir();
		String dir = jprj.getPath().toOSString();
		return new Path(PathTools.getPath(dir, outdir));
	}

	public IPath getTestNgOutDirAbs(IJavaProject jprj) {
		MagicTestProperties props = getProjectProperties(jprj);
		final String outdir = props.getOutputDir();
		String dir = jprj.getProject().getLocation().toOSString();
		return new Path(PathTools.getPath(dir, outdir));
	}

	public IPath getMagicTestOutPath(IJavaProject jprj) {
		MagicTestProperties props = getProjectProperties(jprj);
		final String outdir = props.getMagicTestDir();
		String dir = jprj.getPath().toOSString();
		return new Path(PathTools.getPath(dir, outdir));
	}

	public IPath getMagicTestOutPathAbs(IJavaProject jprj) {
		MagicTestProperties props = getProjectProperties(jprj);
		final String outdir = props.getMagicTestDir();
		String dir = jprj.getProject().getLocation().toOSString();
		return new Path(PathTools.getPath(dir, outdir));
	}

	public MagicTestProperties getProjectProperties(String prjName) {
		return getProjectProperties(JdtTools.getJavaProject(prjName));
	}

	public MagicTestProperties getProjectProperties(IJavaProject jprj) {
		String prjName = jprj.getElementName();
		MagicTestProperties props = propertiesMap.get(prjName);
		if (props != null) {
			return props;
		}
		props = readProjectProperties(jprj);
		MagicTestProperties wsProps = getWorkspaceProperties();
		if (props.getMagicTestDir().isEmpty()) {
			props.setMagicTestDir(wsProps.getMagicTestDir());
		}
		if (props.getOutputDir().isEmpty()) {
			props.setOutputDir(wsProps.getOutputDir());
		}
		propertiesMap.put(prjName, props);
		props.save();
		return props;
	}

	public MagicTestProperties readProjectProperties(IJavaProject jprj) {
		MagicTestProperties props = new MagicTestProperties();
		String dir = jprj.getProject().getLocation().toOSString();
		props.load(dir);
		return props;
	}

	MagicTestProperties getWorkspaceProperties() {
		MagicTestProperties props = propertiesMap.get(null);
		if (props != null) {
			return props;
		}

		props = new MagicTestProperties();
		String magicTestDir = m_storage.getString(TestNGPluginConstants.S_MAGICTEST_OUTDIR);
		if (magicTestDir.isEmpty()) {
			magicTestDir = TestRunner.MAGICTEST_DIR;
		}
		props.setMagicTestDir(magicTestDir);

		String outputDir = m_storage.getString(TestNGPluginConstants.S_TESTNG_OUTDIR);
		if (outputDir.isEmpty()) {
			outputDir = TestNG.DEFAULT_OUTPUTDIR;
		}
		props.setOutputDir(outputDir);

		propertiesMap.put(null, props);
		return props;
	}

	public String getMagicTestOutDir2(String projectName, boolean projectOnly) {
		if (projectOnly
				|| m_storage.contains(projectName
						+ TestNGPluginConstants.S_MAGICTEST_OUTDIR)) {
			return m_storage.getString(projectName
					+ TestNGPluginConstants.S_MAGICTEST_OUTDIR);
		} else {
			String outdir = m_storage
					.getString(TestNGPluginConstants.S_MAGICTEST_OUTDIR);
			return !"".equals(outdir) ? outdir : TestNG.DEFAULT_OUTPUTDIR;
		}
	}

	public String getTestNgOutDir2(String projectName, boolean projectOnly) {
		if (projectOnly
				|| m_storage.contains(projectName
						+ TestNGPluginConstants.S_TESTNG_OUTDIR)) {
			return m_storage.getString(projectName
					+ TestNGPluginConstants.S_TESTNG_OUTDIR);
		} else {
			String outdir = m_storage
					.getString(TestNGPluginConstants.S_TESTNG_OUTDIR);
			return !"".equals(outdir) ? outdir : TestNG.DEFAULT_OUTPUTDIR;
		}
	}

	public boolean getUseProjectJar2(String projectName) {
		return m_storage.getBoolean(projectName
				+ TestNGPluginConstants.S_USEPROJECTJAR);
	}

	private String getString(String projectName, boolean projectOnly,
			String prefName) {
		if (projectOnly || m_storage.contains(projectName + prefName)) {
			return m_storage.getString(projectName + prefName);
		} else {
			return m_storage.getString(prefName);
		}
	}

	// public String getReporters(String projectName, boolean projectOnly) {
	// return getString(projectName, projectOnly,
	// TestNGPluginConstants.S_REPORTERS);
	// }

	// public String getParallel(String projectName, boolean projectOnly) {
	// String result = getString(projectName, projectOnly,
	// TestNGPluginConstants.S_PARALLEL);
	// return Utils.isEmpty(result) ? "false" : result;
	// }

	public boolean hasDisabledListeners(String projectName, boolean projectOnly) {
		if (projectOnly
				|| m_storage.contains(projectName
						+ TestNGPluginConstants.S_DISABLEDLISTENERS)) {
			return m_storage.getBoolean(projectName
					+ TestNGPluginConstants.S_DISABLEDLISTENERS);
		} else {
			return m_storage
					.getBoolean(TestNGPluginConstants.S_DISABLEDLISTENERS);
		}
	}

	public boolean getWatchResults(String projectName) {
		return m_storage.getBoolean(projectName
				+ TestNGPluginConstants.S_WATCH_RESULTS);
	}

	public String getWatchResultDirectory(String projectName) {
		return m_storage.getString(projectName
				+ TestNGPluginConstants.S_WATCH_RESULT_DIRECTORY);
	}

	public void storeWatchResults(String projectName, boolean selection) {
		m_storage.setValue(projectName + TestNGPluginConstants.S_WATCH_RESULTS,
				selection);
	}

	public void storeWatchResultLocation(String projectName, String text) {
		m_storage.setValue(projectName
				+ TestNGPluginConstants.S_WATCH_RESULT_DIRECTORY, text);
	}
}
