package org.magictest.eclipse;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.magictest.ext.org.slf4j.LoggerFactory;

import org.magictest.ext.ch.qos.logback.classic.Logger;

/**
 * Implementation of IHandler for MagicTest.
 * The received events are simply delegated to an instance of PluginTestRunner.
 *
 * @author Thomas Mauch
 * @version $Id$
 */
public class RunProfileTestHandler extends AbstractHandler {
  /** Logger */
  private static Logger LOG = (Logger) LoggerFactory.getLogger(BrowserSupport.class);

   public Object execute(ExecutionEvent event) throws ExecutionException {
      try {
         CommandHandler runner = new CommandHandler(event);
         runner.runProfileTest();
      }
      catch (Exception e) {
         LOG.info("Unexpected execption", e);
      }
      return null;
   }

}
