package org.magictest.testng.eclipse.properties;

import org.magictest.ext.org.magicwerk.brownies.core.PropertiesFile;
import org.magictest.ext.org.magicwerk.brownies.core.files.PathTools;

/**
 * MagicTest properties per project.
 *
 * @author Thomas Mauch
 * @version $Id$
 */
public class MagicTestProperties {
	public static final String PROP_FILE = ".magictest";
	public static final String MAGICTEST_DIR = "magicTestDir";
	public static final String OUTPUT_DIR = "outputDir";
	public static final String USE_PROJECT_JAR = "useProjectJar";

	private PropertiesFile propFile = new PropertiesFile();
	private String magicTestDir;
	private String outputDir;
	private boolean useProjectJar;

	public MagicTestProperties copy() {
		MagicTestProperties props = new MagicTestProperties();
		props.magicTestDir = magicTestDir;
		props.outputDir = outputDir;
		props.useProjectJar = useProjectJar;
		return props;
	}

	public void load(String dir) {
		String file = PathTools.getPath(dir, PROP_FILE);
		propFile.load(file, false);

		magicTestDir = propFile.getString(MAGICTEST_DIR, "");
		outputDir = propFile.getString(OUTPUT_DIR, "");
		useProjectJar = propFile.getBoolean(USE_PROJECT_JAR, false, true);
	}

	public void save() {
		propFile.setString(MAGICTEST_DIR, magicTestDir);
		propFile.setString(OUTPUT_DIR, outputDir);
		propFile.setBoolean(USE_PROJECT_JAR, useProjectJar);

		propFile.save();
	}

	public String getMagicTestDir() {
		return magicTestDir;
	}

	public void setMagicTestDir(String magicTestDir) {
		this.magicTestDir = magicTestDir;
	}

	public String getOutputDir() {
		return outputDir;
	}

	public void setOutputDir(String outputDir) {
		this.outputDir = outputDir;
	}

	public boolean isUseProjectJar() {
		return useProjectJar;
	}

	public void setUseProjectJar(boolean useProjectJar) {
		this.useProjectJar = useProjectJar;
	}

}
