package org.magictest.eclipse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import org.magictest.ext.ch.qos.logback.classic.spi.ILoggingEvent;
import org.magictest.ext.ch.qos.logback.core.OutputStreamAppender;
import org.magictest.testng.eclipse.MagicTestPlugin;

/**
 * A custom Logback appender which redirects output to the Eclipse error log.
 *
 * @author Thomas Mauch
 * @version $Id$
 */
public class LogAppender extends OutputStreamAppender<ILoggingEvent> {

	ByteArrayOutputStream baos = new ByteArrayOutputStream();

	@Override
	public void start() {
		this.setOutputStream(baos);
		super.start();
	}

	@Override
	protected void append(ILoggingEvent event) {
		baos.reset();
		try {
			this.encoder.doEncode(event);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		String out = baos.toString();
		String level = event.getLevel().toString();
		String msg = level + ": " + out;
		MagicTestPlugin.log(msg);
	}
}
