package org.magictest.eclipse;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.magictest.eclipse.tools.JdtTools;
import org.magictest.testng.eclipse.util.LaunchUtil;

/**
 * Run test using MagicTestNG.
 *
 * @author Thomas Mauch
 * @version $Id$
 */
public class MagicTestNGLauncher {

	static void runTest(SelectInfo selectInfo, boolean profile) {
		IJavaElement je = null;
		if (selectInfo.sourceFolder != null) {
			je = JdtTools.getSourceFolder(selectInfo.projectName, selectInfo.sourceFolder);
		} else if (selectInfo.packageName != null) {
			je = JdtTools.getPackage(selectInfo.projectName, selectInfo.packageName);
		} else if (selectInfo.methodName != null) {
			IType type = JdtTools.getType(selectInfo.projectName, selectInfo.className);
			IMethod method = JdtTools.getTestMethod(selectInfo.projectName, selectInfo.className, selectInfo.methodName);
			if (method.getDeclaringType() == type) {
				je = method;
			} else {
				LaunchUtil.launchMethodConfiguration(type.getJavaProject(), type, method, "run", profile, null);
			}
		} else {
			je = JdtTools.getType(selectInfo.projectName, selectInfo.className);
		}
		if (je != null) {
			run(je, "run", profile);
		}
	}

	// Copied from TestNGLaunchShortcut.java
	/**
	 * @param ije
	 * @param mode	launch mode - run or debug
	 */
	private static void run(IJavaElement ije, String mode, boolean profile) {
		IJavaProject ijp = ije.getJavaProject();

		switch (ije.getElementType()) {
		case IJavaElement.PACKAGE_FRAGMENT_ROOT:
			LaunchUtil.launchSourceFolderConfiguration(ijp, (IPackageFragmentRoot) ije, mode, profile);
			break;
		case IJavaElement.PACKAGE_FRAGMENT:
			LaunchUtil.launchPackageConfiguration(ijp, (IPackageFragment) ije, mode, profile);
			break;
		case IJavaElement.COMPILATION_UNIT: {
			List<ICompilationUnit> icu = new ArrayList<ICompilationUnit>(1);
			icu.add((ICompilationUnit) ije);
			LaunchUtil.launchCompilationUnitConfiguration(ijp, icu, mode, profile);
		}
			break;
		case IJavaElement.TYPE:
			LaunchUtil.launchTypeConfiguration(ijp, (IType) ije, mode, profile);
			break;
		case IJavaElement.METHOD:
			LaunchUtil.launchMethodConfiguration(ijp, null, (IMethod) ije, mode, profile, null);
			break;
		}
	}
}
