package org.magictest.eclipse.tools;

import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * Tools supporting Eclipse windows and pages.
 *
 * @author Thomas Mauch
 * @version $Id$
 */
public class WorkbenchTools {
    
    public static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public static IWorkbenchWindow getActiveWindow(IWorkbench workbench) {
        if (workbench == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow();
    }
    
    public static IWorkbenchWindow getActiveWindow() {
        return getActiveWindow(getWorkbench());
    }
    
    public static IWorkbenchPage getActivePage(IWorkbenchWindow window) {
        if (window == null) {
            return null;
        }        
        return window.getActivePage();
    }
    
    public static IWorkbenchPage getActivePage() {
        return getActivePage(getActiveWindow());
    }
    
    /**
     * Show view with specified identifier.
     * 
     * @param viewId id of view to show
     * @return       shown view part or null
     */
    public static IViewPart showView(String viewId) {
        IWorkbenchPage page = getActivePage();
        if (page != null) {
            try {
                return page.showView(viewId);
            }
            catch (PartInitException e) {
                return null;
            }
        }
        return null;
    }
    
    public static boolean hideView(String viewId) {
        IWorkbenchPage page = getActivePage();
        if (page != null) {
            IViewReference viewRef = page.findViewReference(viewId); 
            if (viewRef != null) {
                page.hideView(viewRef);
                return true;
            }
        }
        return false;
    }
    
}
