package org.magictest.testng.eclipse.launch.tester;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.magictest.testng.eclipse.MagicTestPlugin;
import org.magictest.testng.eclipse.util.SuiteFileValidator;


/**
 * Property tester contributing the org.testng.eclipse.isSuite property to
 * file matching the criteria: *.xml, instanceof IFile and being a suite.
 * 
 * @author <a href='mailto:the_mindstorm@evolva.ro'>Alexandru Popescu</a>
 */
public class FileExtender extends PropertyTester {
//  private static final String PROPERTY_IS_Test= "isSuite"; //$NON-NLS-1$

  public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
    if(!(receiver instanceof IFile)) {
      return false;
    }
    MagicTestPlugin.log("Validating suite file:" + receiver);
    try {
      return SuiteFileValidator.isSuiteDefinition((IFile) receiver);
    }
    catch(CoreException ce) {
      MagicTestPlugin.log(ce);
    }

    return false;
  }
}
