/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.magictest.testng.eclipse.ui;


import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.texteditor.ITextEditor;
import org.magictest.testng.eclipse.MagicTestPlugin;
import org.magictest.testng.eclipse.util.JDTUtil;
import org.magictest.testng.eclipse.util.ResourceUtil;

/**
 * Open a class on a Test method.
 */
public class OpenTestAction extends OpenEditorAction {

  private String fMethodName;
  private ISourceRange fRange;
  private RunInfo fRunInfo;

  public OpenTestAction(TestRunnerViewPart testRunner, RunInfo runInfo) {
    this(testRunner, runInfo.getClassName(), runInfo.getMethodName(), true);
    fRunInfo= runInfo;
  }
  
  public OpenTestAction(TestRunnerViewPart testRunner, RunInfo runInfo, boolean activate) {
    this(testRunner, runInfo.getClassName(), runInfo.getMethodName(), activate);
    fRunInfo= runInfo;
  }
  
  /**
   * Constructor for OpenTestAction.
   */
//  public OpenTestAction(TestRunnerViewPart testRunner, String className, String method) {
//    this(testRunner, className, method, true);
//  }

  public OpenTestAction(TestRunnerViewPart testRunner, String className) {
    this(testRunner, className, null, true);
  }

  public OpenTestAction(TestRunnerViewPart testRunner, String className, String method,
      boolean activate) {
    super(testRunner, className, activate);
    fMethodName = method;
  }

  protected IJavaElement findElement(IJavaProject project, String className)
  throws JavaModelException {
    IJavaElement javaElement= null;
    if( null != fRunInfo) {
      javaElement= JDTUtil.findElement(project, fRunInfo);
    }
    else {
      javaElement= JDTUtil.findElement(project, className, fMethodName, null);
    }
    
    if(null == fMethodName) {
      return javaElement;
    }
    
    IMethod method= (IMethod) javaElement;

    if(null == method) {
      String title = ResourceUtil.getString("OpenTestAction.error.title"); //$NON-NLS-1$
      String message = ResourceUtil.getFormattedString("OpenTestAction.error.methodNoFound", //$NON-NLS-1$
                                                       fMethodName);
      MessageDialog.openInformation(getShell(), title, message);

      return JDTUtil.findElement(project, className);
    }
    fRange = method.getNameRange();
    
    return javaElement;
  }

  protected void reveal(ITextEditor textEditor) {
    if (fRange != null) {
      textEditor.selectAndReveal(fRange.getOffset(), fRange.getLength());
    }
  }

  public boolean isEnabled() {
    if(null == getClassName()) {
	  // HINT: should never happen now
      return false;
    }
    
    try {
      IJavaProject project = getLaunchedProject();
      if (project != null) return project.findType(getClassName()) != null;
      else return false;
    }
    catch (JavaModelException e) {
    }

    return false;
  }

}
