package org.magictest.testng.eclipse.ui;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.magictest.eclipse.BrowserSupport;
import org.magictest.eclipse.SelectInfo;
import org.magictest.testng.eclipse.util.ResourceUtil;

/**
 * Action for showing the reference report.
 */
public class ShowReferenceReportAction extends Action {
    protected IJavaProject javaProject;
    protected RunInfo runInfo;

    /**
     * Constructor for ShowReportAction.
     */
    public ShowReferenceReportAction(IJavaProject javaProject, RunInfo runInfo) {
        super(ResourceUtil.getString("ShowReferenceReportAction.action.label")); //$NON-NLS-1$ // FIXME
        this.javaProject = javaProject;
        this.runInfo = runInfo;
    }

    @Override
    public void run() {
        SelectInfo si = new SelectInfo();
        si.projectName = javaProject.getElementName();
        si.className = runInfo.getClassName();
        si.methodName = runInfo.getMethodName();
        BrowserSupport.showReferenceReport(si);
    }

}
