package org.magictest.testng.eclipse.ui.preferences;


import org.eclipse.debug.internal.ui.preferences.BooleanFieldEditor2;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.magictest.testng.eclipse.MagicTestPlugin;
import org.magictest.testng.eclipse.TestNGPluginConstants;

import java.io.File;

/**
 * Workspace wide preferences for MagicTest.
 */
public class PreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {
  private DirectoryFieldEditor m_testNgOutDir;
  private DirectoryFieldEditor m_magicTestOutDir;
  //private BooleanFieldEditor2 m_absolutePath;
  private BooleanFieldEditor2 m_disabledDefaultListeners;
  private FileFieldEditor m_xmlTemplateFile;

  public PreferencePage() {
    super(GRID);
    setPreferenceStore(MagicTestPlugin.getDefault().getPreferenceStore());
    setDescription("MagicTest workbench preferences"); //$NON-NLS-1$
  }

  @Override
  public void init(IWorkbench workbench) {
  }

  /**
   * Creates the field editors. Field editors are abstractions of
   * the common GUI blocks needed to manipulate various types
   * of preferences. Each field editor knows how to save and
   * restore itself.
   */
  @Override
  public void createFieldEditors() {
    Composite parentComposite= getFieldEditorParent();
    m_magicTestOutDir= new FSBrowseDirectoryFieldEditor(TestNGPluginConstants.S_MAGICTEST_OUTDIR,
        "MagicTest output directory:", //$NON-NLS-1$
        parentComposite);
    m_magicTestOutDir.fillIntoGrid(parentComposite, 3);

    m_testNgOutDir= new FSBrowseDirectoryFieldEditor(TestNGPluginConstants.S_TESTNG_OUTDIR,
            "TestNG output directory:", //$NON-NLS-1$
            parentComposite);
        m_testNgOutDir.fillIntoGrid(parentComposite, 3);

        //Button btn= m_testNgOutDir.getChangeControl(parentComposite);
//    btn.addSelectionListener(new SelectionAdapter() {
//      @Override
//      public void widgetSelected(SelectionEvent evt) {
//        m_absolutePath.getChangeControl(getFieldEditorParent()).setSelection(true);
//      }
//    });
//
//    m_absolutePath= new BooleanFieldEditor2(TestNGPluginConstants.S_ABSOLUTEPATH,
//        "Absolute output path", //$NON-NLS-1$
//        SWT.NONE,
//        parentComposite);
//    m_testNgOutDir.setAbsolutePathVerifier(m_absolutePath);

//    m_disabledDefaultListeners= new BooleanFieldEditor2(TestNGPluginConstants.S_DISABLEDLISTENERS,
//        "Disable default listeners", //$NON-NLS-1$
//        SWT.NONE,
//        parentComposite);
//
//    // XML template
//    m_xmlTemplateFile = new FileFieldEditor(TestNGPluginConstants.S_XML_TEMPLATE_FILE,
//        "Template XML file:", false /* no absolute */,
//        StringButtonFieldEditor.VALIDATE_ON_FOCUS_LOST,
//        parentComposite);
//    m_xmlTemplateFile.setEmptyStringAllowed(true);
//    m_xmlTemplateFile.fillIntoGrid(parentComposite, 3);

    addField(m_magicTestOutDir);
    addField(m_testNgOutDir);
  }



  private static class FSBrowseDirectoryFieldEditor extends DirectoryFieldEditor {
    public FSBrowseDirectoryFieldEditor(String name, String labelText, Composite parent) {
      super(name, labelText, parent);
    }

    @Override
    protected boolean doCheckState() {
    	return true;
    }
  }
}
