/*
 * Decompiled with CFR 0.152.
 */
package majordodo.embedded;

import java.lang.management.ManagementFactory;
import java.util.UUID;
import java.util.function.Supplier;
import majordodo.embedded.EmbeddedWorkerConfiguration;
import majordodo.executors.TaskExecutorFactory;
import majordodo.network.BrokerLocator;
import majordodo.network.jvm.JVMBrokerLocator;
import majordodo.network.netty.NettyBrokerLocator;
import majordodo.replication.ZKBrokerLocator;
import majordodo.worker.WorkerCore;
import majordodo.worker.WorkerCoreConfiguration;

public class EmbeddedWorker {
    private WorkerCore workerCore;
    private final WorkerCoreConfiguration workerConfiguration = new WorkerCoreConfiguration();
    private TaskExecutorFactory taskExecutorFactory;
    private BrokerLocator brokerLocator;
    private final EmbeddedWorkerConfiguration configuration;

    public EmbeddedWorker(EmbeddedWorkerConfiguration configuration) {
        this.configuration = configuration;
    }

    public WorkerCore getWorkerCore() {
        return this.workerCore;
    }

    public WorkerCoreConfiguration getWorkerConfiguration() {
        return this.workerConfiguration;
    }

    public TaskExecutorFactory getTaskExecutorFactory() {
        return this.taskExecutorFactory;
    }

    public void setTaskExecutorFactory(TaskExecutorFactory taskExecutorFactory) {
        this.taskExecutorFactory = taskExecutorFactory;
    }

    public BrokerLocator getBrokerLocator() {
        return this.brokerLocator;
    }

    public void setBrokerLocator(BrokerLocator brokerLocator) {
        this.brokerLocator = brokerLocator;
    }

    public void start() throws Exception {
        String host = this.configuration.getStringProperty("worker.broker.host", "localhost");
        int port = this.configuration.getIntProperty("worker.broker.port", 7862);
        boolean ssl = this.configuration.getBooleanProperty("worker.broker.ssl", false);
        String mode = this.configuration.getStringProperty("mode", "singleserver");
        String zkAdress = this.configuration.getStringProperty("zk.address", "localhost:1281");
        String zkPath = this.configuration.getStringProperty("zk.path", "/majordodo");
        int zkSessionTimeout = this.configuration.getIntProperty("zk.sessiontimeout", 40000);
        Supplier supplier = (Supplier)this.configuration.getProperty("zk.client.supplier", null);
        boolean sslUnsecure = this.configuration.getBooleanProperty("worker.broker.ssl.unsecure", true);
        switch (mode) {
            case "jvmonly": {
                this.brokerLocator = new JVMBrokerLocator(null);
                break;
            }
            case "singleserver": {
                this.brokerLocator = new NettyBrokerLocator(host, port, ssl);
                ((NettyBrokerLocator)this.brokerLocator).setSslUnsecure(sslUnsecure);
                break;
            }
            case "clustered": {
                this.brokerLocator = supplier != null ? new ZKBrokerLocator(supplier, zkPath) : new ZKBrokerLocator(zkAdress, zkSessionTimeout, zkPath);
                ((ZKBrokerLocator)this.brokerLocator).setSslUnsecure(sslUnsecure);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported mode " + mode);
            }
        }
        String sharedSecret = this.configuration.getStringProperty("sharedsecret", "dodo");
        this.workerConfiguration.setSharedSecret(sharedSecret);
        this.workerConfiguration.read(this.configuration.getProperties());
        String processId = ManagementFactory.getRuntimeMXBean().getName() + "_" + UUID.randomUUID().toString();
        this.workerCore = new WorkerCore(this.workerConfiguration, processId, this.brokerLocator, null);
        if (this.taskExecutorFactory != null) {
            this.workerCore.setExecutorFactory(this.taskExecutorFactory);
        }
        this.workerCore.start();
    }

    public void stop() {
        if (this.workerCore != null) {
            this.workerCore.stop();
        }
    }

    public boolean waitForAllExecutorsToFinish(int timeout) throws InterruptedException {
        long now = System.currentTimeMillis();
        while (System.currentTimeMillis() - now <= (long)timeout) {
            if (this.workerCore.getRunningTaskIds().isEmpty()) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }
}

