/*
 * Decompiled with CFR 0.152.
 */
package majordodo.embedded;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import majordodo.client.BrokerStatus;
import majordodo.client.ClientConnection;
import majordodo.client.ClientException;
import majordodo.client.CodePoolStatus;
import majordodo.client.CreateCodePoolResult;
import majordodo.client.SubmitTaskRequest;
import majordodo.client.SubmitTaskResponse;
import majordodo.client.TaskStatus;
import majordodo.client.TaskSubmitter;
import majordodo.clientfacade.AddTaskRequest;
import majordodo.clientfacade.BrokerStatusView;
import majordodo.clientfacade.CodePoolView;
import majordodo.clientfacade.CreateCodePoolRequest;
import majordodo.clientfacade.SubmitTaskResult;
import majordodo.clientfacade.TaskStatusView;
import majordodo.network.jvm.JVMBrokersRegistry;
import majordodo.task.Broker;

public class EmbeddedClient
implements AutoCloseable {
    public ClientConnection openConnection() {
        return new EmbeddedBrokerConnection((Broker)JVMBrokersRegistry.getDefaultBroker());
    }

    @Override
    public void close() {
    }

    private static class EmbeddedBrokerConnection
    implements ClientConnection {
        Broker broker;
        long transactionId;
        boolean transacted;
        TaskSubmitter submitter;

        public TaskSubmitter submitter() {
            if (this.submitter == null) {
                this.submitter = new TaskSubmitter((ClientConnection)this);
            }
            return this.submitter;
        }

        public EmbeddedBrokerConnection(Broker broker) {
            if (broker == null) {
                throw new IllegalStateException("embedded broker not registered, maybe it has not started yet");
            }
            this.broker = broker;
        }

        public void close() throws ClientException {
        }

        public void commit() throws ClientException {
            if (this.transactionId > 0L) {
                try {
                    this.broker.getClient().commitTransaction(this.transactionId);
                }
                catch (Exception err) {
                    throw new ClientException((Throwable)err);
                }
                this.transactionId = 0L;
            }
        }

        public BrokerStatus getBrokerStatus() throws ClientException {
            BrokerStatus res = new BrokerStatus();
            BrokerStatusView brokerStatus = this.broker.getClient().getBrokerStatus();
            res.setCurrentLedgerId("" + brokerStatus.getCurrentLedgerId());
            res.setCurrentSequenceNumber("" + brokerStatus.getCurrentSequenceNumber());
            res.setErrortasks(brokerStatus.getErrorTasks());
            res.setFinishedtasks(brokerStatus.getFinishedTasks());
            res.setPendingtasks(brokerStatus.getPendingTasks());
            res.setRunningtasks(brokerStatus.getRunningTasks());
            res.setStatus(brokerStatus.getClusterMode());
            res.setTasks(brokerStatus.getTasks());
            res.setVersion(Broker.VERSION());
            res.setWaitingtasks(brokerStatus.getWaitingTasks());
            return res;
        }

        public TaskStatus getTaskStatus(String id) throws ClientException {
            TaskStatusView t = this.broker.getClient().getTask(Long.parseLong(id));
            if (t == null) {
                return null;
            }
            TaskStatus res = new TaskStatus();
            res.setAttempts(t.getAttempts());
            res.setCreatedTimestamp(t.getCreatedTimestamp());
            res.setData(t.getData());
            res.setDeadline(t.getExecutionDeadline());
            res.setMaxattempts(t.getMaxattempts());
            res.setResult(t.getResult());
            res.setSlot(t.getSlot());
            String status = TaskStatusView.convertTaskStatusForClient((int)t.getStatus());
            res.setStatus(status);
            res.setTaskId("" + t.getTaskId());
            res.setTasktype(t.getType());
            res.setUserId(t.getUser());
            res.setWorkerId(t.getWorkerId());
            return res;
        }

        protected void beginTransaction() throws ClientException {
            try {
                this.transactionId = this.broker.getClient().beginTransaction();
            }
            catch (Exception err) {
                throw new ClientException((Throwable)err);
            }
        }

        public boolean isTransacted() {
            return this.transacted;
        }

        public void rollback() throws ClientException {
            if (this.transactionId > 0L) {
                try {
                    this.broker.getClient().rollbackTransaction(this.transactionId);
                }
                catch (Exception err) {
                    throw new ClientException((Throwable)err);
                }
            }
        }

        public void setTransacted(boolean transacted) {
            if (this.transactionId > 0L) {
                throw new IllegalStateException("cannot change transaction mode during transaction");
            }
            this.transacted = transacted;
        }

        public SubmitTaskResponse submitTask(SubmitTaskRequest request) throws ClientException {
            this.ensureTransaction();
            long deadline = 0L;
            if (request.getTimeToLive() > 0L) {
                deadline = System.currentTimeMillis() + request.getTimeToLive();
            }
            try {
                if (request.getTasktype() == null || request.getTasktype().isEmpty()) {
                    throw new ClientException("invalid tasktype " + request.getTasktype());
                }
                if (request.getMaxattempts() < 0) {
                    throw new ClientException("invalid Maxattempts " + request.getMaxattempts());
                }
                if (request.getAttempt() > 0 && request.getMaxattempts() > 0 && request.getAttempt() >= request.getMaxattempts()) {
                    throw new ClientException("invalid Maxattempts " + request.getMaxattempts() + " with attempt " + request.getAttempt());
                }
                SubmitTaskResult submitTask = this.broker.getClient().submitTask(new AddTaskRequest(this.transactionId, request.getTasktype(), request.getUserid(), request.getData(), request.getMaxattempts(), request.getRequestedStartTime(), deadline, request.getSlot(), request.getAttempt(), null, null));
                SubmitTaskResponse resp = new SubmitTaskResponse();
                resp.setTaskId("" + submitTask.getTaskId());
                if (submitTask.getOutcome() != null) {
                    resp.setOutcome(submitTask.getOutcome());
                } else {
                    resp.setOutcome("");
                }
                return resp;
            }
            catch (Exception err) {
                throw new ClientException((Throwable)err);
            }
        }

        public List<SubmitTaskResponse> submitTasks(List<SubmitTaskRequest> requestlist) throws ClientException {
            this.ensureTransaction();
            ArrayList<AddTaskRequest> requests = new ArrayList<AddTaskRequest>(requestlist.size());
            for (SubmitTaskRequest request : requestlist) {
                long deadline = 0L;
                if (request.getTimeToLive() > 0L) {
                    deadline = System.currentTimeMillis() + request.getTimeToLive();
                }
                if (request.getTasktype() == null || request.getTasktype().isEmpty()) {
                    throw new ClientException("invalid tasktype " + request.getTasktype());
                }
                if (request.getMaxattempts() < 0) {
                    throw new ClientException("invalid Maxattempts " + request.getMaxattempts());
                }
                if (request.getAttempt() > 0 && request.getMaxattempts() > 0 && request.getAttempt() >= request.getMaxattempts()) {
                    throw new ClientException("invalid Maxattempts " + request.getMaxattempts() + " with attempt " + request.getAttempt());
                }
                requests.add(new AddTaskRequest(this.transactionId, request.getTasktype(), request.getUserid(), request.getData(), request.getMaxattempts(), request.getRequestedStartTime(), deadline, request.getSlot(), request.getAttempt(), null, null));
            }
            try {
                List submitTasks = this.broker.getClient().submitTasks(requests);
                ArrayList<SubmitTaskResponse> results = new ArrayList<SubmitTaskResponse>(requestlist.size());
                for (SubmitTaskResult submitTask : submitTasks) {
                    SubmitTaskResponse resp = new SubmitTaskResponse();
                    resp.setTaskId("" + submitTask.getTaskId());
                    if (submitTask.getOutcome() != null) {
                        resp.setOutcome(submitTask.getOutcome());
                    } else {
                        resp.setOutcome("");
                    }
                    results.add(resp);
                }
                return results;
            }
            catch (Exception err) {
                throw new ClientException((Throwable)err);
            }
        }

        public CreateCodePoolResult createCodePool(majordodo.client.CreateCodePoolRequest request) throws ClientException {
            try {
                majordodo.clientfacade.CreateCodePoolResult res = this.broker.getClient().createCodePool(new CreateCodePoolRequest(request.getCodePoolID(), System.currentTimeMillis(), request.getTtl(), request.getCodePoolData().getBytes(StandardCharsets.UTF_8)));
                CreateCodePoolResult cr = new CreateCodePoolResult();
                if (!res.ok) {
                    throw new Exception("createCodePool failed " + res.outcome);
                }
                cr.setOk(true);
                return cr;
            }
            catch (Exception err) {
                throw new ClientException((Throwable)err);
            }
        }

        public void deleteCodePool(String codePoolId) throws ClientException {
            try {
                this.broker.getClient().deleteCodePool(codePoolId);
            }
            catch (Exception err) {
                throw new ClientException((Throwable)err);
            }
        }

        public CodePoolStatus getCodePoolStatus(String codePoolId) throws ClientException {
            try {
                CodePoolView codePool = this.broker.getClient().getCodePool(codePoolId);
                if (codePool == null) {
                    return null;
                }
                CodePoolStatus s = new CodePoolStatus();
                s.setCreationTimestamp(codePool.getCreationTimestamp());
                s.setId(codePool.getCodePoolId());
                return s;
            }
            catch (Exception ex) {
                throw new ClientException((Throwable)ex);
            }
        }

        private void ensureTransaction() throws ClientException {
            if (this.transacted && this.transactionId <= 0L) {
                this.beginTransaction();
            }
        }
    }
}

