/*
 * Decompiled with CFR 0.152.
 */
package majordodo.embedded;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import majordodo.clientfacade.AuthenticationManager;
import majordodo.embedded.EmbeddedBrokerConfiguration;
import majordodo.network.BrokerHostData;
import majordodo.network.ServerSideConnectionAcceptor;
import majordodo.network.netty.NettyChannelAcceptor;
import majordodo.replication.ReplicatedCommitLog;
import majordodo.task.Broker;
import majordodo.task.BrokerConfiguration;
import majordodo.task.FileCommitLog;
import majordodo.task.GlobalResourceLimitsConfiguration;
import majordodo.task.MemoryCommitLog;
import majordodo.task.NoLimitsGlobalResourceLimitsConfiguration;
import majordodo.task.StatusChangesLog;
import majordodo.task.TaskProperties;
import majordodo.task.TaskPropertiesMapperFunction;
import majordodo.task.TasksHeap;

public class EmbeddedBroker
implements AutoCloseable {
    private Broker broker;
    private BrokerConfiguration brokerConfiguration;
    private TaskPropertiesMapperFunction taskPropertiesMapperFunction = new TaskPropertiesMapperFunction(){

        public TaskProperties getTaskProperties(long taskid, String taskType, String userid) {
            return new TaskProperties(1, null);
        }
    };
    private StatusChangesLog statusChangesLog;
    private NettyChannelAcceptor server;
    private final EmbeddedBrokerConfiguration configuration;
    private Runnable brokerDiedCallback;
    private AuthenticationManager authenticationManager;
    private GlobalResourceLimitsConfiguration globalResourceLimitsConfiguration = new NoLimitsGlobalResourceLimitsConfiguration();

    public GlobalResourceLimitsConfiguration getGlobalResourceLimitsConfiguration() {
        return this.globalResourceLimitsConfiguration;
    }

    public void setGlobalResourceLimitsConfiguration(GlobalResourceLimitsConfiguration globalResourceLimitsConfiguration) {
        this.globalResourceLimitsConfiguration = globalResourceLimitsConfiguration;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public Runnable getBrokerDiedCallback() {
        return this.brokerDiedCallback;
    }

    public void setBrokerDiedCallback(Runnable brokerDiedCallback) {
        this.brokerDiedCallback = brokerDiedCallback;
    }

    public EmbeddedBroker(EmbeddedBrokerConfiguration configuration) {
        this.configuration = configuration;
    }

    public EmbeddedBrokerConfiguration getConfiguration() {
        return this.configuration;
    }

    public TaskPropertiesMapperFunction getTaskPropertiesMapperFunction() {
        return this.taskPropertiesMapperFunction;
    }

    public void setTaskPropertiesMapperFunction(TaskPropertiesMapperFunction taskPropertiesMapperFunction) {
        this.taskPropertiesMapperFunction = taskPropertiesMapperFunction;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public BrokerConfiguration getBrokerConfiguration() {
        return this.brokerConfiguration;
    }

    public void start() throws Exception {
        String id = this.configuration.getStringProperty(EmbeddedBrokerConfiguration.KEY_BROKERID, "");
        if (id.isEmpty()) {
            id = UUID.randomUUID().toString();
        }
        String host = this.configuration.getStringProperty(EmbeddedBrokerConfiguration.KEY_HOST, "localhost");
        int workerthreads = this.configuration.getIntProperty(EmbeddedBrokerConfiguration.KEY_BROKERWORKERTHREADS, 16);
        int port = this.configuration.getIntProperty(EmbeddedBrokerConfiguration.KEY_PORT, 7862);
        boolean ssl = this.configuration.getBooleanProperty(EmbeddedBrokerConfiguration.KEY_SSL, false);
        File certfile = (File)this.configuration.getProperty(EmbeddedBrokerConfiguration.SSL_CERTIFICATE_FILE, null);
        File certchainfile = (File)this.configuration.getProperty(EmbeddedBrokerConfiguration.SSL_CERTIFICATE_CHAIN_FILE, null);
        String sslciphers = this.configuration.getProperty(EmbeddedBrokerConfiguration.SSL_CIPHERS, "").toString();
        String certpassword = this.configuration.getStringProperty(EmbeddedBrokerConfiguration.SSL_CERTIFICATE_PASSWORD, null);
        String mode = this.configuration.getStringProperty("mode", "singleserver");
        String logDirectory = this.configuration.getStringProperty(EmbeddedBrokerConfiguration.KEY_LOGSDIRECTORY, "txlog");
        String snapshotsDirectory = this.configuration.getStringProperty(EmbeddedBrokerConfiguration.KEY_SNAPSHOTSDIRECTORY, "snapshots");
        String zkAdress = this.configuration.getStringProperty(EmbeddedBrokerConfiguration.KEY_ZKADDRESS, "localhost:1281");
        String zkPath = this.configuration.getStringProperty(EmbeddedBrokerConfiguration.KEY_ZKPATH, "/majordodo");
        String clientapiurl = this.configuration.getStringProperty(EmbeddedBrokerConfiguration.KEY_CLIENTAPIURL, "");
        int zkSessionTimeout = this.configuration.getIntProperty(EmbeddedBrokerConfiguration.KEY_ZKSESSIONTIMEOUT, 40000);
        long maxFileSize = this.configuration.getIntProperty(EmbeddedBrokerConfiguration.KEY_LOGSMAXFILESIZE, 0x100000);
        HashMap<String, String> additionalInfo = new HashMap<String, String>();
        additionalInfo.put("client.api.url", clientapiurl);
        additionalInfo.put("broker.id", id);
        switch (mode) {
            case "jvmonly": {
                this.statusChangesLog = new MemoryCommitLog();
                break;
            }
            case "singleserver": {
                Path _snapshotsDirectory;
                Path _logDirectory = Paths.get(logDirectory, new String[0]);
                if (!Files.isDirectory(_logDirectory, new LinkOption[0])) {
                    Files.createDirectory(_logDirectory, new FileAttribute[0]);
                }
                if (!Files.isDirectory(_snapshotsDirectory = Paths.get(snapshotsDirectory, new String[0]), new LinkOption[0])) {
                    Files.createDirectory(_snapshotsDirectory, new FileAttribute[0]);
                }
                this.statusChangesLog = new FileCommitLog(_logDirectory, _snapshotsDirectory, maxFileSize);
                break;
            }
            case "clustered": {
                Path _snapshotsDirectory = Paths.get(snapshotsDirectory, new String[0]);
                if (!Files.isDirectory(_snapshotsDirectory, new LinkOption[0])) {
                    Files.createDirectory(_snapshotsDirectory, new FileAttribute[0]);
                }
                ReplicatedCommitLog _statusChangesLog = new ReplicatedCommitLog(zkAdress, zkSessionTimeout, zkPath, _snapshotsDirectory, BrokerHostData.formatHostdata((BrokerHostData)new BrokerHostData(host, port, Broker.VERSION(), ssl, additionalInfo)));
                this.statusChangesLog = _statusChangesLog;
                int ensemble = this.configuration.getIntProperty(EmbeddedBrokerConfiguration.KEY_BK_ENSEMBLE_SIZE, _statusChangesLog.getEnsemble());
                int writeQuorumSize = this.configuration.getIntProperty(EmbeddedBrokerConfiguration.KEY_BK_WRITEQUORUMSIZE, _statusChangesLog.getWriteQuorumSize());
                int ackQuorumSize = this.configuration.getIntProperty(EmbeddedBrokerConfiguration.KEY_BK_ACKQUORUMSIZE, _statusChangesLog.getAckQuorumSize());
                long ledgersRetentionPeriod = this.configuration.getLongProperty(EmbeddedBrokerConfiguration.KEY_BK_LEDGERSRETENTIONPERIOD, _statusChangesLog.getLedgersRetentionPeriod());
                _statusChangesLog.setAckQuorumSize(ackQuorumSize);
                _statusChangesLog.setEnsemble(ensemble);
                _statusChangesLog.setLedgersRetentionPeriod(ledgersRetentionPeriod);
                _statusChangesLog.setWriteQuorumSize(writeQuorumSize);
                break;
            }
        }
        this.brokerConfiguration = new BrokerConfiguration();
        String sharedSecret = this.configuration.getStringProperty("sharedsecret", "dodo");
        this.brokerConfiguration.setSharedSecret(sharedSecret);
        this.brokerConfiguration.read(this.configuration.getProperties());
        this.broker = new Broker(this.brokerConfiguration, this.statusChangesLog, new TasksHeap(this.brokerConfiguration.getTasksHeapSize(), this.taskPropertiesMapperFunction));
        this.broker.setAuthenticationManager(this.authenticationManager);
        this.broker.setGlobalResourceLimitsConfiguration(this.globalResourceLimitsConfiguration);
        this.broker.setBrokerId(id);
        switch (mode) {
            case "jvmonly": {
                break;
            }
            case "singleserver": 
            case "clustered": {
                this.server = new NettyChannelAcceptor((ServerSideConnectionAcceptor)this.broker.getAcceptor(), host, port);
                this.server.setSslCertChainFile(certchainfile);
                if (sslciphers != null && !sslciphers.isEmpty()) {
                    this.server.setSslCiphers(Stream.of(sslciphers.split(",")).map(s -> s.trim()).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
                }
                this.server.setSslCertFile(certfile);
                this.server.setSslCertPassword(certpassword);
                this.server.setSsl(ssl);
                this.server.setWorkerThreads(workerthreads);
            }
        }
        this.broker.setBrokerDiedCallback(this.brokerDiedCallback);
        this.broker.start();
        if (this.server != null) {
            this.server.start();
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.close();
        }
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    @Override
    public void close() {
        this.stop();
    }
}

