/*
 * Decompiled with CFR 0.152.
 */
package com.plato.util.html;

import com.plato.util.html.Tag;
import com.plato.util.html.TagInstance;
import java.util.Deque;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mantoux.util.datastructures.InsertStringBuilder;

public class HTMLSearchableCompression {
    static final String ESCAPE = "#";
    private static final String TAGS_DELIMIT = "#tags#";
    private Deque<TagInstance> tags = new LinkedList<TagInstance>();
    private Deque<TagInstance> selfClosings = new LinkedList<TagInstance>();
    private String plainText;

    public Deque<TagInstance> getTags() {
        LinkedList<TagInstance> tempTags = new LinkedList<TagInstance>();
        LinkedList<TagInstance> cloneTags = new LinkedList<TagInstance>();
        for (TagInstance t : this.tags) {
            tempTags.push(t);
        }
        for (TagInstance t : tempTags) {
            cloneTags.push(t);
        }
        return cloneTags;
    }

    public Deque<TagInstance> getSelfClosings() {
        LinkedList<TagInstance> tempTags = new LinkedList<TagInstance>();
        LinkedList<TagInstance> cloneTags = new LinkedList<TagInstance>();
        for (TagInstance t : this.selfClosings) {
            tempTags.push(t);
        }
        for (TagInstance t : tempTags) {
            cloneTags.push(t);
        }
        return cloneTags;
    }

    public String getPlainText() {
        return this.plainText;
    }

    public static String decode(String plain, Deque<TagInstance> inTags, Deque<TagInstance> sClosings) {
        HTMLSearchableCompression c = new HTMLSearchableCompression();
        c.tags = inTags;
        c.selfClosings = sClosings;
        c.plainText = plain;
        InsertStringBuilder html = new InsertStringBuilder();
        LinkedList<TagInstance> ts = new LinkedList<TagInstance>();
        int index = plain.length();
        c.processSelfClosingTags(sClosings, html, index);
        index = c.plainText.length();
        html = new InsertStringBuilder();
        while (c.tags.peek() != null) {
            TagInstance t = (TagInstance)ts.peek();
            if (t != null && c.tags.peek().to() <= t.from()) {
                index = c.processOpeningTags(html, ts, index);
                continue;
            }
            index = c.processClosingTags(html, ts, index);
        }
        while (ts.peek() != null) {
            index = c.processOpeningTags(html, ts, index);
        }
        return html.insertFirst(c.plainText.substring(0, index)).toString();
    }

    public static HTMLSearchableCompression deserializeString(String in) {
        HTMLSearchableCompression c = new HTMLSearchableCompression();
        String[] tmp = in.split(TAGS_DELIMIT);
        if (tmp.length < 2) {
            return c;
        }
        for (String sTag : tmp[1].split("#tag")) {
            if ("".equals(sTag.trim())) continue;
            c.tags.add(TagInstance.deserializeString(sTag, false));
        }
        if (tmp.length < 3) {
            return c;
        }
        for (String sTag : tmp[2].split("#tag")) {
            if ("".equals(sTag.trim())) continue;
            c.selfClosings.add(TagInstance.deserializeString(sTag, true));
        }
        return c;
    }

    public static String decode(String plain, String tags) {
        HTMLSearchableCompression c = HTMLSearchableCompression.deserializeString(tags);
        return HTMLSearchableCompression.decode(plain, c.getTags(), c.getSelfClosings());
    }

    public void encode(String in) {
        Pattern pattern = Pattern.compile(Tag.getRegex());
        Matcher m = pattern.matcher(in);
        int nextToParseIndex = 0;
        StringBuilder sbPlainText = new StringBuilder();
        LinkedList<TagInstance> tempStack = new LinkedList<TagInstance>();
        int offset = 0;
        int closingOffset = 0;
        while (m.find()) {
            String sTag = in.substring(m.start(), m.end());
            TagInstance tInstance = sTag.charAt(1) != '/' ? this.getTagOpening(m, tempStack, offset, closingOffset, sTag) : this.getTagClosing(m, tempStack, offset, sTag);
            sbPlainText.append(in.substring(nextToParseIndex, m.start()));
            nextToParseIndex = m.start() + sTag.length();
            if (!tInstance.tagName().isSelfClosing) {
                offset += sTag.length();
                continue;
            }
            closingOffset += sTag.length();
        }
        this.plainText = sbPlainText.append(in.substring(nextToParseIndex)).toString();
    }

    public String serializeTagsString() {
        StringBuilder s = new StringBuilder();
        s.append(TAGS_DELIMIT);
        for (TagInstance t : this.tags) {
            s.append("#tag").append(t.serializeString());
        }
        s.append(TAGS_DELIMIT);
        for (TagInstance t : this.selfClosings) {
            s.append("#tag").append(t.serializeString());
        }
        return s.toString();
    }

    private TagInstance getTagOpening(Matcher m, Deque<TagInstance> tempStack, int offset, int closingOffset, String sTag) {
        TagInstance tInstance;
        Tag tName = Tag.isTag(sTag);
        if (tName != null && tName.isSelfClosing) {
            tInstance = new TagInstance(sTag, m.start() - closingOffset - offset);
            tInstance.findAttributes(sTag);
            this.selfClosings.push(tInstance);
        } else {
            tInstance = new TagInstance(sTag, m.start() - offset);
            tInstance.findAttributes(sTag);
            tempStack.push(tInstance);
        }
        return tInstance;
    }

    private TagInstance getTagClosing(Matcher m, Deque<TagInstance> tempStack, int offset, String sTag) {
        TagInstance tInstance = tempStack.pop();
        String sTagName = Tag.prepareString(sTag);
        if (tInstance == null || !tInstance.tagName().toString().equals(sTagName)) {
            throw new IllegalArgumentException("Parser error - closing tag doesn't match current opening tag\n" + sTag);
        }
        tInstance.setRangeTo(m.start() - offset);
        this.tags.push(tInstance);
        return tInstance;
    }

    private void processSelfClosingTags(Deque<TagInstance> sClosings, InsertStringBuilder html, int index) {
        int idx = index;
        while (sClosings.peek() != null) {
            TagInstance t = sClosings.pop();
            html.insertFirst(t.openingString() + this.plainText.substring(t.to(), idx));
            idx = t.from();
        }
        html.insertFirst(this.plainText.substring(0, idx));
        this.plainText = html.toString();
    }

    private int processOpeningTags(InsertStringBuilder html, Deque<TagInstance> ts, int index) {
        TagInstance t = ts.pop();
        String s = this.plainText.substring(t.from(), index);
        html.insertFirst(t.openingString() + s);
        return t.from();
    }

    private int processClosingTags(InsertStringBuilder html, Deque<TagInstance> ts, int index) {
        TagInstance t = this.tags.pop();
        String s = this.plainText.substring(t.to(), index);
        html.insertFirst(t.closingString() + s);
        ts.push(t);
        return t.to();
    }

    static String notBewteenQuotesRegex(String s) {
        return s + "(?:(?<=[\"]" + s + ")|(?=[\"]))";
    }
}

