/*
 * Decompiled with CFR 0.152.
 */
package org.mantoux.util.datastructures;

public class InsertStringBuilder {
    private char[] value;
    private int size = 0;

    public InsertStringBuilder() {
        this.value = new char[16];
    }

    public InsertStringBuilder(int capacity) {
        this.value = capacity > 0 ? new char[capacity] : new char[16];
    }

    public InsertStringBuilder insertFirst(String str) {
        if (str == null) {
            return this;
        }
        char[] strChars = str.toCharArray();
        int len = str.length();
        this.ensureCapacityInternal(this.size + len);
        this.size += len;
        System.arraycopy(strChars, 0, this.value, this.offset(), len);
        return this;
    }

    private void ensureCapacityInternal(int minimumCapacity) {
        if (minimumCapacity - this.value.length > 0) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private int offset() {
        return this.value.length - this.size;
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = this.value.length * 2 + 2;
        if (newCapacity - minimumCapacity < 0) {
            newCapacity = minimumCapacity;
        }
        if (newCapacity < 0) {
            if (minimumCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        char[] copy = new char[newCapacity];
        System.arraycopy(this.value, this.offset(), copy, newCapacity - this.size, this.size);
        this.value = copy;
    }

    public String toString() {
        return new String(this.value, this.offset(), this.size);
    }
}

