/*
 * Decompiled with CFR 0.152.
 */
package org.mantoux.util.datastructures;

import java.util.Iterator;
import java.util.Objects;

public class Stack<ITEM>
implements Iterable<ITEM> {
    private Node first = null;
    private int size = 0;

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void push(ITEM element) {
        if (!this.isEmpty()) {
            Node oldFirst = this.first;
            this.first = new Node(element, oldFirst);
        } else {
            this.addToEmptyList(element);
        }
        ++this.size;
    }

    public ITEM pop() {
        if (!this.isEmpty()) {
            Object popped = this.first.content;
            this.first = this.first.next;
            --this.size;
            return popped;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public ITEM peek() {
        if (this.first == null) {
            return null;
        }
        return this.first.content;
    }

    private void addToEmptyList(ITEM element) {
        this.first = new Node(element, null);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)o;
        if (this.first == null && other.first == null) {
            return true;
        }
        if (this.first == null || other.first == null) {
            return false;
        }
        if (!Objects.equals(this.first.content, other.first.content)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        Iterator<ITEM> it = this.iterator();
        Iterator<ITEM> oIt = other.iterator();
        while (it.hasNext()) {
            if (Objects.equals(it.next(), oIt.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stackString = new StringBuilder();
        Iterator<ITEM> it = this.iterator();
        stackString.append("Stack elements:\n");
        while (it.hasNext()) {
            stackString.append(it.next().toString());
            stackString.append("\n");
        }
        return stackString.deleteCharAt(stackString.length() - 1).toString();
    }

    @Override
    public Iterator<ITEM> iterator() {
        return new StackIterator();
    }

    private class StackIterator
    implements Iterator<ITEM> {
        private Node currentNode;

        private StackIterator() {
            this.currentNode = Stack.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public ITEM next() {
            Object next = this.currentNode.content;
            this.currentNode = this.currentNode.next;
            return next;
        }
    }

    private class Node {
        ITEM content;
        Node next;

        private Node(ITEM content, Node next) {
            this.content = content;
            this.next = next;
        }
    }
}

