/*
 * Decompiled with CFR 0.152.
 */
package org.mantoux.util.datastructures;

import java.util.Iterator;

public class Queue<Item>
implements Iterable<Item> {
    private Node first = null;
    private Node last = null;
    private int size = 0;

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void enqueue(Item element) {
        if (!this.isEmpty()) {
            this.last = this.last.next = new Node(element, null);
        } else {
            this.addToEmptyList(element);
        }
        ++this.size;
    }

    public Item dequeue() {
        if (!this.isEmpty()) {
            Object element = this.first.content;
            this.first = this.first.next;
            --this.size;
            return element;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    private void addToEmptyList(Item element) {
        this.last = this.first = new Node(element, null);
    }

    @Override
    public Iterator<Item> iterator() {
        return new QueueIterator();
    }

    private class QueueIterator
    implements Iterator<Item> {
        Node currentNode;

        private QueueIterator() {
            this.currentNode = Queue.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public Item next() {
            Object next = this.currentNode.content;
            this.currentNode = this.currentNode.next;
            return next;
        }
    }

    private class Node {
        Item content;
        Node next;

        private Node(Item content, Node next) {
            this.content = content;
            this.next = next;
        }
    }
}

