/*
 * Decompiled with CFR 0.152.
 */
package org.mantoux.util.datastructures;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AccumTST<V> {
    private Node<V> root;

    public void put(String key, V val) {
        key = key.toLowerCase();
        this.root = this.put(this.root, key, val, 0);
    }

    public Set<V> get(String key) {
        String lkey = key.toLowerCase();
        Node<V> x = this.get(this.root, lkey, 0);
        if (x == null) {
            return Collections.emptySet();
        }
        return x.val;
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public void delete(String key, V val) {
        Node<V> x = this.get(this.root, key, 0);
        if (x != null && x.val != null) {
            x.val.remove(val);
            if (x.val.isEmpty()) {
                x.val = null;
            }
        }
    }

    public Collection<V> valuesWithPrefix(String prefix) {
        HashSet set = new HashSet();
        Node<V> x = this.get(this.root, prefix.toLowerCase(), 0);
        if (x == null) {
            return set;
        }
        if (x.val != null) {
            set.addAll(x.val);
        }
        this.collect(x.mid, new StringBuilder(prefix), set);
        return set;
    }

    private Node<V> put(Node<V> x, String key, V val, int d) {
        char c = key.charAt(d);
        if (x == null) {
            x = new Node();
            x.c = c;
        }
        if (c < x.c) {
            x.left = this.put(x.left, key, val, d);
        } else if (c > x.c) {
            x.right = this.put(x.right, key, val, d);
        } else if (d < key.length() - 1) {
            x.mid = this.put(x.mid, key, val, d + 1);
        } else {
            if (x.val == null) {
                x.val = new HashSet();
            }
            x.val.add(val);
        }
        return x;
    }

    private Node<V> get(Node<V> x, String key, int d) {
        char c = key.charAt(d);
        if (x == null) {
            return null;
        }
        if (c < x.c) {
            return this.get(x.left, key, d);
        }
        if (c > x.c) {
            return this.get(x.right, key, d);
        }
        if (d < key.length() - 1) {
            return this.get(x.mid, key, d + 1);
        }
        return x;
    }

    private void collect(Node<V> x, StringBuilder prefix, Set<V> l) {
        if (x == null) {
            return;
        }
        this.collect(x.left, prefix, l);
        if (x.val != null) {
            l.addAll(x.val);
        }
        this.collect(x.mid, prefix.append(x.c), l);
        prefix.deleteCharAt(prefix.length() - 1);
        this.collect(x.right, prefix, l);
    }

    Collection<V> keys() {
        return null;
    }

    private static class Node<V> {
        private Set<V> val;
        private char c;
        private Node<V> left;
        private Node<V> mid;
        private Node<V> right;

        private Node() {
        }
    }
}

