/*
 * Decompiled with CFR 0.152.
 */
package org.mantoux.delta;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class AttributeMap
extends HashMap<String, Object> {
    public AttributeMap(AttributeMap b) {
        super(b);
    }

    public AttributeMap() {
    }

    private AttributeMap(Map<String, Object> input) {
        super(input);
    }

    public AttributeMap copy() {
        return new AttributeMap(this);
    }

    static AttributeMap of(String key, Object value) {
        HashMap<String, Object> temp = new HashMap<String, Object>();
        temp.put(key, value);
        return new AttributeMap((Map<String, Object>)temp);
    }

    static AttributeMap of(String key0, Object value0, String key1, Object value1) {
        HashMap<String, Object> temp = new HashMap<String, Object>();
        temp.put(key0, value0);
        temp.put(key1, value1);
        return new AttributeMap((Map<String, Object>)temp);
    }

    static AttributeMap of(String key0, Object value0, String key1, Object value1, String key2, Object value2) {
        HashMap<String, Object> temp = new HashMap<String, Object>();
        temp.put(key0, value0);
        temp.put(key1, value1);
        temp.put(key2, value2);
        return new AttributeMap((Map<String, Object>)temp);
    }

    static AttributeMap of(String key0, Object value0, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        HashMap<String, Object> temp = new HashMap<String, Object>();
        temp.put(key0, value0);
        temp.put(key1, value1);
        temp.put(key2, value2);
        temp.put(key3, value3);
        return new AttributeMap((Map<String, Object>)temp);
    }

    static AttributeMap compose(AttributeMap a, AttributeMap b, boolean keepNull) {
        AttributeMap _a = a != null ? a : new AttributeMap();
        AttributeMap _b = b != null ? b : new AttributeMap();
        AttributeMap attributes = new AttributeMap(_b);
        if (!keepNull) {
            HashSet keysToRemove = new HashSet();
            attributes.forEach((key, value) -> {
                if (value == null) {
                    keysToRemove.add(key);
                }
            });
            keysToRemove.forEach(attributes::remove);
        }
        for (String key2 : _a.keySet()) {
            if (_a.get(key2) == null || _b.containsKey(key2)) continue;
            attributes.put(key2, _a.get(key2));
        }
        return attributes.isEmpty() ? null : new AttributeMap(attributes);
    }

    static AttributeMap compose(AttributeMap a, AttributeMap b) {
        return AttributeMap.compose(a, b, false);
    }

    static AttributeMap diff(AttributeMap a, AttributeMap b) {
        AttributeMap _a = a != null ? a : new AttributeMap();
        AttributeMap _b = b != null ? b : new AttributeMap();
        AttributeMap attributes = new AttributeMap();
        HashSet keys = new HashSet(_a.keySet());
        keys.addAll(_b.keySet());
        for (String k : keys) {
            if (Objects.equals(_a.get(k), _b.get(k))) continue;
            attributes.put(k, _b.get(k));
        }
        return attributes.isEmpty() ? null : attributes;
    }

    static AttributeMap invert(AttributeMap attr, AttributeMap base) {
        AttributeMap _attr = attr != null ? attr : new AttributeMap();
        AttributeMap _base = base != null ? base : new AttributeMap();
        AttributeMap baseInverted = new AttributeMap();
        for (String k : _base.keySet()) {
            if (_base.get(k).equals(_attr.get(k)) || !_attr.containsKey(k)) continue;
            baseInverted.put(k, _base.get(k));
        }
        for (String k : _attr.keySet()) {
            if (Objects.equals(_attr.get(k), _base.get(k)) || _base.containsKey(k)) continue;
            baseInverted.put(k, null);
        }
        return baseInverted;
    }

    static AttributeMap transform(AttributeMap a, AttributeMap b) {
        return AttributeMap.transform(a, b, false);
    }

    static AttributeMap transform(AttributeMap a, AttributeMap b, boolean priority) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return null;
        }
        if (!priority) {
            return b;
        }
        AttributeMap attributes = new AttributeMap();
        for (String k : b.keySet()) {
            if (a.containsKey(k)) continue;
            attributes.put(k, b.get(k));
        }
        return attributes.isEmpty() ? null : attributes;
    }
}

