/*
 * Decompiled with CFR 0.152.
 */
package org.mantoux.delta;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mantoux.delta.AttributeMap;
import org.mantoux.delta.Op;
import org.mantoux.delta.OpList;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Delta {
    @JsonProperty(value="ops")
    final OpList ops;

    public Delta(OpList ops) {
        if (ops == null) {
            throw new IllegalArgumentException("Ops cannot be null, use Delta() for empty ops");
        }
        this.ops = ops;
    }

    public Delta() {
        this(new OpList());
    }

    public Delta(Delta delta) {
        this(delta.ops);
    }

    public OpList getOps() {
        return new OpList(this.ops);
    }

    public Delta insert(String arg, AttributeMap attributes) {
        if (arg == null) {
            return this;
        }
        if (arg.isBlank()) {
            return this;
        }
        return this.push(Op.insert(arg, attributes));
    }

    public Delta insert(String arg) {
        return this.insert(arg, null);
    }

    public Delta delete(int length) {
        if (length <= 0) {
            return this;
        }
        return this.push(Op.delete(length));
    }

    public Delta retain(int length, AttributeMap attributes) {
        if (length <= 0) {
            return this;
        }
        return this.push(Op.retain(length, attributes));
    }

    public Delta retain(int length) {
        return this.retain(length, null);
    }

    public Delta push(Op newOp) {
        if (this.ops.isEmpty()) {
            this.ops.add(newOp);
            return this;
        }
        int index = this.ops.size();
        Op lastOp = (Op)this.ops.get(index - 1);
        if ((newOp = newOp.copy()).isDelete() && lastOp.isDelete()) {
            this.ops.set(index - 1, Op.delete(lastOp.length() + newOp.length()));
            return this;
        }
        if (lastOp.isDelete() && newOp.isInsert()) {
            if (--index == 0) {
                this.ops.insertFirst(newOp);
                return this;
            }
            lastOp = (Op)this.ops.get(index - 1);
        }
        if (Objects.equals(newOp.attributes(), lastOp.attributes())) {
            if (newOp.isInsert() && lastOp.isInsert() && newOp.arg() instanceof String && lastOp.arg() instanceof String) {
                Op mergedOp = Op.insert(lastOp.argAsString() + newOp.argAsString(), newOp.attributes());
                this.ops.set(index - 1, mergedOp);
                return this;
            }
            if (lastOp.isRetain() && newOp.isRetain()) {
                Op mergedOp = Op.retain(lastOp.length() + newOp.length(), newOp.attributes());
                this.ops.set(index - 1, mergedOp);
                return this;
            }
        }
        if (index == this.ops.size()) {
            this.ops.add(newOp);
        } else {
            this.ops.add(index, newOp);
        }
        return this;
    }

    public Delta chop() {
        if (this.ops.isEmpty()) {
            return this;
        }
        Op lastOp = (Op)this.ops.get(this.ops.size() - 1);
        if (lastOp.isRetain() && lastOp.attributes() == null) {
            this.ops.removeLast();
        }
        return this;
    }

    public OpList filter(Predicate<Op> predicate) {
        return this.ops.filter(predicate);
    }

    public void forEach(Consumer<Op> consumer) {
        this.ops.forEach(consumer);
    }

    public <T> List<T> map(Function<Op, T> mapper) {
        return this.ops.stream().map(mapper).collect(Collectors.toList());
    }

    public List<Op>[] partition(Predicate<Op> predicate) {
        OpList passed = new OpList();
        OpList failed = new OpList();
        this.forEach(op -> {
            if (predicate.test((Op)op)) {
                passed.add(op);
            } else {
                failed.add(op);
            }
        });
        return new OpList[]{passed, failed};
    }

    public <T> T reduce(T initialValue, BiFunction<T, Op, T> accumulator) {
        return this.ops.stream().reduce(initialValue, accumulator, (value1, value2) -> value2);
    }

    public int changeLength() {
        return this.reduce(0, (length, op) -> {
            if (op.isInsert()) {
                return length + op.length();
            }
            if (op.isDelete()) {
                return length - op.length();
            }
            return length;
        });
    }

    public int length() {
        return this.reduce(0, (length, op) -> length + op.length());
    }

    public Delta slice(int start) {
        return this.slice(start, Integer.MAX_VALUE);
    }

    public Delta compose(Delta other) {
        OpList.Iterator it = this.ops.iterator();
        OpList.Iterator otherIt = other.ops.iterator();
        OpList combined = new OpList();
        Op firstOther = otherIt.peek();
        if (firstOther != null && firstOther.isRetain() && firstOther.attributes() == null) {
            int firstLeft;
            for (firstLeft = firstOther.length(); it.peekType() == Op.Type.INSERT && it.peekLength() <= firstLeft; firstLeft -= it.peekLength()) {
                combined.add(it.next());
            }
            if (firstOther.length() - firstLeft > 0) {
                otherIt.next(firstOther.length() - firstLeft);
            }
        }
        Delta delta = new Delta(combined);
        while (it.hasNext() || otherIt.hasNext()) {
            if (otherIt.peekType() == Op.Type.INSERT) {
                delta.push(otherIt.next());
                continue;
            }
            if (it.peekType() == Op.Type.DELETE) {
                delta.push(it.next());
                continue;
            }
            int length = Math.min(it.peekLength(), otherIt.peekLength());
            Op thisOp = it.next(length);
            Op otherOp = otherIt.next(length);
            if (otherOp.isRetain()) {
                AttributeMap attributes = AttributeMap.compose(thisOp.attributes(), otherOp.attributes(), thisOp.isRetain());
                Op newOp = thisOp.isRetain() ? Op.retain(length, attributes) : Op.insert(thisOp.arg(), attributes);
                delta.push(newOp);
                if (otherIt.hasNext() || !((Op)delta.ops.get(delta.ops.size() - 1)).equals(newOp)) continue;
                Delta rest = new Delta(it.rest());
                return delta.concat(rest).chop();
            }
            if (!otherOp.isDelete() || !thisOp.isRetain()) continue;
            delta.push(otherOp);
        }
        return delta.chop();
    }

    public void eachLine(BiFunction<Delta, AttributeMap, Boolean> predicate, String newLine) {
        OpList.Iterator it = this.ops.iterator();
        Delta line = new Delta();
        int i = 0;
        while (it.hasNext()) {
            int index;
            if (it.peekType() != Op.Type.INSERT) {
                return;
            }
            Op thisOp = it.peek();
            int start = thisOp.length() - it.peekLength();
            int n = index = thisOp.isTextInsert() ? thisOp.argAsString().indexOf(newLine, start) - start : -1;
            if (index < 0) {
                line.push(it.next());
                continue;
            }
            if (index > 0) {
                line.push(it.next(index));
                continue;
            }
            if (!predicate.apply(line, it.next(1).attributes()).booleanValue()) {
                return;
            }
            ++i;
            line = new Delta();
        }
        if (line.length() > 0) {
            predicate.apply(line, null);
        }
    }

    public void eachLine(BiFunction<Delta, AttributeMap, Boolean> applyFunction) {
        this.eachLine(applyFunction, "\n");
    }

    public Delta invert(Delta base) {
        Delta inverted = new Delta();
        this.reduce(0, (baseIndex, op) -> {
            if (op.isInsert()) {
                inverted.delete(op.length());
            } else {
                if (op.isRetain() && op.attributes() == null) {
                    inverted.retain(op.length());
                    return baseIndex + op.length();
                }
                if (op.isDelete() || op.isRetain() && op.hasAttributes()) {
                    int length = op.length();
                    Delta slice = base.slice((int)baseIndex, baseIndex + length);
                    slice.forEach(baseOp -> {
                        if (op.isDelete()) {
                            inverted.push((Op)baseOp);
                        } else if (op.isRetain() && op.hasAttributes()) {
                            inverted.retain(baseOp.length(), AttributeMap.invert(op.attributes(), baseOp.attributes()));
                        }
                    });
                    return baseIndex + length;
                }
            }
            return baseIndex;
        });
        return inverted.chop();
    }

    public Delta slice(int start, int end) {
        Op nextOp;
        OpList ops = new OpList();
        OpList.Iterator it = this.ops.iterator();
        for (int index = 0; index < end && it.hasNext(); index += nextOp.length()) {
            if (index < start) {
                nextOp = it.next(start - index);
                continue;
            }
            nextOp = it.next(end - index);
            ops.add(nextOp);
        }
        return new Delta(ops);
    }

    public Delta concat(Delta other) {
        Delta delta = new Delta(new OpList(this.ops));
        if (!other.ops.isEmpty()) {
            delta.push((Op)other.ops.get(0));
            delta.ops.addAll(other.ops.subList(1, other.ops.size()));
        }
        return delta;
    }

    public int hashCode() {
        return Objects.hash(this.ops);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Delta delta = (Delta)o;
        return Objects.equals(this.ops, delta.ops);
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        try {
            return writer.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "Error while generating json:\n" + e.getMessage();
        }
    }
}

