/*
 * Decompiled with CFR 0.152.
 */
package org.mantoux.delta;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.mantoux.delta.AttributeMap;
import org.mantoux.delta.OpDeserializer;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using=OpDeserializer.class)
public class Op {
    static final String EMBED = String.valueOf('\u200b');
    @JsonProperty
    private Object insert;
    @JsonProperty
    private Integer delete;
    @JsonProperty
    private Integer retain;
    @JsonProperty
    private AttributeMap attributes;

    public static Op insert(Object arg) {
        if (arg instanceof String) {
            return Op.insert(arg, null);
        }
        Op newOp = new Op();
        newOp.insert = arg;
        return newOp;
    }

    public static Op insert(Object arg, AttributeMap attributes) {
        Op newOp = new Op();
        if (attributes != null && attributes.size() > 0) {
            if (arg instanceof String) {
                newOp.attributes = attributes;
            } else {
                throw new IllegalArgumentException("Cannot insert object with attributes");
            }
        }
        newOp.insert = arg;
        return newOp;
    }

    public static Op retain(int length) {
        return Op.retain(length, null);
    }

    public static Op retain(int length, AttributeMap attributes) {
        if (length <= 0) {
            throw new IllegalArgumentException("Length should be greater than 0");
        }
        Op newOp = new Op();
        if (attributes != null && attributes.size() > 0) {
            newOp.attributes = attributes;
        }
        newOp.retain = length;
        return newOp;
    }

    public static Op delete(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Length should be greater than 0");
        }
        Op newOp = new Op();
        newOp.delete = length;
        return newOp;
    }

    static Op retainUntilEnd() {
        return Op.retain(Integer.MAX_VALUE);
    }

    @JsonIgnore
    public boolean isDelete() {
        return this.type().equals((Object)Type.DELETE);
    }

    @JsonIgnore
    public boolean isInsert() {
        return this.type().equals((Object)Type.INSERT);
    }

    @JsonIgnore
    public boolean isTextInsert() {
        return this.isInsert() && this.insert instanceof String;
    }

    @JsonIgnore
    public boolean isRetain() {
        return this.type().equals((Object)Type.RETAIN);
    }

    public Type type() {
        if (this.insert != null) {
            return Type.INSERT;
        }
        if (this.delete != null) {
            return Type.DELETE;
        }
        if (this.retain != null) {
            return Type.RETAIN;
        }
        throw new IllegalStateException("Op has no insert, delete or retain");
    }

    public Op copy() {
        switch (this.type()) {
            case RETAIN: {
                return Op.retain(this.retain, this.attributes != null ? this.attributes.copy() : null);
            }
            case DELETE: {
                return Op.delete(this.delete);
            }
            case INSERT: {
                return Op.insert(this.insert, this.attributes != null ? this.attributes.copy() : null);
            }
        }
        throw new IllegalStateException("Op has no insert, delete or retain");
    }

    public int length() {
        if (this.type().equals((Object)Type.DELETE)) {
            return this.delete;
        }
        if (this.type().equals((Object)Type.RETAIN)) {
            return this.retain;
        }
        return this.insert instanceof String ? ((String)this.insert).length() : 1;
    }

    public AttributeMap attributes() {
        if (this.type().equals((Object)Type.DELETE)) {
            return null;
        }
        return this.attributes != null ? this.attributes.copy() : null;
    }

    public Object arg() {
        if (Type.INSERT.equals((Object)this.type())) {
            return this.insert;
        }
        throw new UnsupportedOperationException("Only insert op has an argument");
    }

    public String argAsString() {
        assert (this.insert instanceof String);
        return (String)this.insert;
    }

    public boolean hasAttributes() {
        if (this.isDelete()) {
            return false;
        }
        return this.attributes != null;
    }

    public int hashCode() {
        return Objects.hash(this.insert, this.delete, this.retain, this.attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Op op = (Op)o;
        return Objects.equals(this.insert, op.insert) && Objects.equals(this.delete, op.delete) && Objects.equals(this.retain, op.retain) && Objects.equals(this.attributes, op.attributes);
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        try {
            return writer.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "Error while generating json:\n" + e.getMessage();
        }
    }

    public static enum Type {
        INSERT,
        DELETE,
        RETAIN;

    }
}

