/*
 * Decompiled with CFR 0.152.
 */
package org.mantoux.delta;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;
import org.mantoux.delta.AttributeMap;
import org.mantoux.delta.Op;

public class OpDeserializer
extends JsonDeserializer<Op> {
    public Op deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode insertNode;
        ObjectCodec codec = jsonParser.getCodec();
        ObjectNode node = (ObjectNode)codec.readTree(jsonParser);
        AttributeMap map = null;
        if (node.findValue("attributes") != null) {
            map = (AttributeMap)codec.treeToValue((TreeNode)node.findValue("attributes"), AttributeMap.class);
        }
        if ((insertNode = node.findValue("insert")) == null || insertNode.isTextual()) {
            if (insertNode != null) {
                return Op.insert(insertNode.asText(), map);
            }
            JsonNode deleteNode = node.findValue("delete");
            if (deleteNode != null) {
                return Op.delete(deleteNode.asInt());
            }
            return Op.retain(node.findValue("retain").asInt(), map);
        }
        Map object = (Map)codec.treeToValue((TreeNode)node.get("insert"), Map.class);
        return Op.insert(object);
    }
}

