/*
 * Decompiled with CFR 0.152.
 */
package org.mantoux.delta;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mantoux.delta.Op;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class OpList
extends ArrayList<Op> {
    public OpList(List<Op> ops) {
        super(ops);
    }

    public OpList() {
    }

    public void insertFirst(Op element) {
        this.add(0, element);
    }

    @Override
    public Op removeLast() {
        return (Op)this.remove(this.size() - 1);
    }

    public OpList filter(Predicate<Op> predicate) {
        return new OpList(this.stream().filter(predicate).collect(Collectors.toList()));
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public static class Iterator
    implements java.util.Iterator<Op> {
        private final OpList ops;
        private int index = 0;
        private int offset = 0;

        Iterator(OpList ops) {
            this.ops = ops;
        }

        public Op next(int length) {
            if (this.index >= this.ops.size()) {
                return Op.retain(Integer.MAX_VALUE, null);
            }
            Op nextOp = (Op)this.ops.get(this.index);
            int offset = this.offset;
            int opLength = nextOp.length();
            if (length >= opLength - offset) {
                length = opLength - offset;
                ++this.index;
                this.offset = 0;
            } else {
                this.offset += length;
            }
            if (nextOp.isDelete()) {
                return Op.delete(length);
            }
            Op retOp = nextOp.isRetain() ? Op.retain(length, nextOp.attributes()) : (nextOp.isTextInsert() ? Op.insert(nextOp.argAsString().substring(offset, offset + length), nextOp.attributes()) : Op.insert(nextOp.arg(), nextOp.attributes()));
            return retOp;
        }

        public Op peek() {
            if (this.index >= this.ops.size()) {
                return null;
            }
            return (Op)this.ops.get(this.index);
        }

        public int peekLength() {
            if (this.index >= this.ops.size()) {
                return Integer.MAX_VALUE;
            }
            return ((Op)this.ops.get(this.index)).length() - this.offset;
        }

        public Op.Type peekType() {
            if (this.index >= this.ops.size()) {
                return Op.Type.RETAIN;
            }
            return ((Op)this.ops.get(this.index)).type();
        }

        public OpList rest() {
            if (!this.hasNext()) {
                return new OpList();
            }
            if (this.offset == 0) {
                return new OpList(this.ops.subList(this.index, this.ops.size()));
            }
            int offset = this.offset;
            int index = this.index;
            Op next = this.next();
            OpList rest = new OpList(this.ops.subList(this.index, this.ops.size()));
            this.offset = offset;
            this.index = index;
            OpList returnList = new OpList(List.of(next));
            returnList.addAll(rest);
            return returnList;
        }

        @Override
        public boolean hasNext() {
            return this.peekLength() < Integer.MAX_VALUE;
        }

        @Override
        public Op next() {
            return this.next(Integer.MAX_VALUE);
        }
    }
}

