/*
 * Decompiled with CFR 0.152.
 */
package org.mantoux.delta;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mantoux.delta.AttributeMap;
import org.mantoux.delta.Op;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Delta
extends ArrayList<Op> {
    public Delta(Collection<Op> other) {
        super(other);
    }

    public Delta() {
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    private void insertFirst(Op element) {
        this.add(0, element);
    }

    public Delta filter(Predicate<Op> predicate) {
        return new Delta(this.stream().filter(predicate).collect(Collectors.toList()));
    }

    public Delta insert(Object arg, AttributeMap attributes) {
        String string;
        if (arg == null) {
            return this;
        }
        if (arg instanceof String && (string = (String)arg).isEmpty()) {
            return this;
        }
        return this.push(Op.insert(arg, attributes));
    }

    public Delta insert(String arg) {
        return this.insert(arg, null);
    }

    public Delta insert(Map<String, Object> object) {
        return this.insert(object, null);
    }

    public Delta delete(int length) {
        if (length <= 0) {
            return this;
        }
        return this.push(Op.delete(length));
    }

    public Delta retain(int length, AttributeMap attributes) {
        if (length <= 0) {
            return this;
        }
        return this.push(Op.retain(length, attributes));
    }

    public Delta retain(int length) {
        return this.retain(length, null);
    }

    public Delta push(Op newOp) {
        if (this.isEmpty()) {
            this.add(newOp);
            return this;
        }
        int index = this.size();
        Op lastOp = (Op)this.get(index - 1);
        if ((newOp = newOp.copy()).isDelete() && lastOp.isDelete()) {
            this.set(index - 1, Op.delete(lastOp.length() + newOp.length()));
            return this;
        }
        if (lastOp.isDelete() && newOp.isInsert()) {
            if (--index == 0) {
                this.insertFirst(newOp);
                return this;
            }
            lastOp = (Op)this.get(index - 1);
        }
        if (Objects.equals(newOp.attributes(), lastOp.attributes())) {
            if (newOp.isInsert() && lastOp.isInsert() && newOp.arg() instanceof String && lastOp.arg() instanceof String) {
                Op mergedOp = Op.insert(lastOp.argAsString() + newOp.argAsString(), newOp.attributes());
                this.set(index - 1, mergedOp);
                return this;
            }
            if (lastOp.isRetain() && newOp.isRetain()) {
                Op mergedOp = Op.retain(lastOp.length() + newOp.length(), newOp.attributes());
                this.set(index - 1, mergedOp);
                return this;
            }
        }
        if (index == this.size()) {
            this.add(newOp);
        } else {
            this.add(index, newOp);
        }
        return this;
    }

    public Delta chop() {
        if (this.isEmpty()) {
            return this;
        }
        Op lastOp = (Op)this.getLast();
        if (lastOp.isRetain() && lastOp.attributes() == null) {
            this.removeLast();
        }
        return this;
    }

    public <T> List<T> map(Function<Op, T> mapper) {
        return this.stream().map(mapper).collect(Collectors.toList());
    }

    public List<Op>[] partition(Predicate<Op> predicate) {
        Delta passed = new Delta();
        Delta failed = new Delta();
        this.forEach((? super E op) -> {
            if (predicate.test((Op)op)) {
                passed.add(op);
            } else {
                failed.add(op);
            }
        });
        return new Delta[]{passed, failed};
    }

    public <T> T reduce(T initialValue, BiFunction<T, Op, T> accumulator) {
        return this.stream().reduce(initialValue, accumulator, (value1, value2) -> value2);
    }

    public int changeLength() {
        return this.reduce(0, (length, op) -> {
            if (op.isInsert()) {
                return length + op.length();
            }
            if (op.isDelete()) {
                return length - op.length();
            }
            return length;
        });
    }

    public int length() {
        return this.reduce(0, (length, op) -> length + op.length());
    }

    public Delta slice(int start) {
        return this.slice(start, Integer.MAX_VALUE);
    }

    public Delta compose(Delta other) {
        Iterator it = this.iterator();
        Iterator otherIt = other.iterator();
        Delta combined = new Delta();
        Op firstOther = otherIt.peek();
        if (firstOther != null && firstOther.isRetain() && firstOther.attributes() == null) {
            int firstLeft;
            for (firstLeft = firstOther.length(); it.peekType() == Op.Type.INSERT && it.peekLength() <= firstLeft; firstLeft -= it.peekLength()) {
                combined.add(it.next());
            }
            if (firstOther.length() - firstLeft > 0) {
                otherIt.next(firstOther.length() - firstLeft);
            }
        }
        Delta delta = new Delta(combined);
        while (it.hasNext() || otherIt.hasNext()) {
            if (otherIt.peekType() == Op.Type.INSERT) {
                delta.push(otherIt.next());
                continue;
            }
            if (it.peekType() == Op.Type.DELETE) {
                delta.push(it.next());
                continue;
            }
            int length = Math.min(it.peekLength(), otherIt.peekLength());
            Op thisOp = it.next(length);
            Op otherOp = otherIt.next(length);
            if (otherOp.isRetain()) {
                AttributeMap attributes = AttributeMap.compose(thisOp.attributes(), otherOp.attributes(), thisOp.isRetain());
                Op newOp = thisOp.isRetain() ? Op.retain(length, attributes) : Op.insert(thisOp.arg(), attributes);
                delta.push(newOp);
                if (otherIt.hasNext() || !((Op)delta.getLast()).equals(newOp)) continue;
                Delta rest = new Delta(it.rest());
                return delta.concat(rest).chop();
            }
            if (!otherOp.isDelete() || !thisOp.isRetain()) continue;
            delta.push(otherOp);
        }
        return delta.chop();
    }

    public void eachLine(BiFunction<Delta, AttributeMap, Boolean> predicate, String newLine) {
        Iterator it = this.iterator();
        Delta line = new Delta();
        while (it.hasNext()) {
            int index;
            if (it.peekType() != Op.Type.INSERT) {
                return;
            }
            Op thisOp = it.peek();
            int start = thisOp.length() - it.peekLength();
            int n = index = thisOp.isTextInsert() ? thisOp.argAsString().indexOf(newLine, start) - start : -1;
            if (index < 0) {
                line.push(it.next());
                continue;
            }
            if (index > 0) {
                line.push(it.next(index));
                continue;
            }
            if (!predicate.apply(line, it.next(1).attributes()).booleanValue()) {
                return;
            }
            line = new Delta();
        }
        if (line.length() > 0) {
            predicate.apply(line, null);
        }
    }

    public void eachLine(BiFunction<Delta, AttributeMap, Boolean> applyFunction) {
        this.eachLine(applyFunction, "\n");
    }

    public Delta invert(Delta base) {
        Delta inverted = new Delta();
        this.reduce(0, (baseIndex, op) -> {
            if (op.isInsert()) {
                inverted.delete(op.length());
            } else {
                if (op.isRetain() && op.attributes() == null) {
                    inverted.retain(op.length());
                    return baseIndex + op.length();
                }
                if (op.isDelete() || op.isRetain() && op.hasAttributes()) {
                    int length = op.length();
                    Delta slice = base.slice((int)baseIndex, baseIndex + length);
                    slice.forEach((? super E baseOp) -> {
                        if (op.isDelete()) {
                            inverted.push((Op)baseOp);
                        } else if (op.isRetain() && op.hasAttributes()) {
                            inverted.retain(baseOp.length(), AttributeMap.invert(op.attributes(), baseOp.attributes()));
                        }
                    });
                    return baseIndex + length;
                }
            }
            return baseIndex;
        });
        return inverted.chop();
    }

    public Delta slice(int start, int end) {
        Op nextOp;
        Delta newDelta = new Delta();
        Iterator it = this.iterator();
        for (int index = 0; index < end && it.hasNext(); index += nextOp.length()) {
            if (index < start) {
                nextOp = it.next(start - index);
                continue;
            }
            nextOp = it.next(end - index);
            newDelta.add(nextOp);
        }
        return newDelta;
    }

    public Delta concat(Delta other) {
        Delta delta = new Delta(this);
        if (!other.isEmpty()) {
            delta.push((Op)other.getFirst());
            delta.addAll(other.subList(1, other.size()));
        }
        return delta;
    }

    public String plainText() {
        StringBuilder builder = new StringBuilder();
        for (Op op : this) {
            if (op.isTextInsert()) {
                builder.append(op.argAsString());
                continue;
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        try {
            return writer.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "Error while generating json:\n" + e.getMessage();
        }
    }

    public static class Iterator
    implements java.util.Iterator<Op> {
        private final Delta delta;
        private int index = 0;
        private int offset = 0;

        Iterator(Delta delta) {
            this.delta = delta;
        }

        public Op next(int length) {
            if (this.index >= this.delta.size()) {
                return Op.retain(Integer.MAX_VALUE, null);
            }
            Op nextOp = (Op)this.delta.get(this.index);
            int offset = this.offset;
            int opLength = nextOp.length();
            if (length >= opLength - offset) {
                length = opLength - offset;
                ++this.index;
                this.offset = 0;
            } else {
                this.offset += length;
            }
            if (nextOp.isDelete()) {
                return Op.delete(length);
            }
            Op retOp = nextOp.isRetain() ? Op.retain(length, nextOp.attributes()) : (nextOp.isTextInsert() ? Op.insert(nextOp.argAsString().substring(offset, offset + length), nextOp.attributes()) : Op.insert(nextOp.arg(), nextOp.attributes()));
            return retOp;
        }

        public Op peek() {
            if (this.index >= this.delta.size()) {
                return null;
            }
            return (Op)this.delta.get(this.index);
        }

        public int peekLength() {
            if (this.index >= this.delta.size()) {
                return Integer.MAX_VALUE;
            }
            return ((Op)this.delta.get(this.index)).length() - this.offset;
        }

        public Op.Type peekType() {
            if (this.index >= this.delta.size()) {
                return Op.Type.RETAIN;
            }
            return ((Op)this.delta.get(this.index)).type();
        }

        public Delta rest() {
            if (!this.hasNext()) {
                return new Delta();
            }
            if (this.offset == 0) {
                return new Delta((Collection<Op>)this.delta.subList(this.index, this.delta.size()));
            }
            int offset = this.offset;
            int index = this.index;
            Op next = this.next();
            Delta rest = new Delta((Collection<Op>)this.delta.subList(this.index, this.delta.size()));
            this.offset = offset;
            this.index = index;
            Delta delta = new Delta((Collection<Op>)List.of(next));
            delta.addAll(rest);
            return delta;
        }

        @Override
        public boolean hasNext() {
            return this.peekLength() < Integer.MAX_VALUE;
        }

        @Override
        public Op next() {
            return this.next(Integer.MAX_VALUE);
        }
    }
}

