/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.maochen.nlp.parser.DNode;

public class DTree
extends ArrayList<DNode> {
    private DNode padding = new DNode();
    private static final String UUID_KEY = "uuid";
    private static final String SENTENCE_TYPE_KEY = "sentence_type";
    private static final String ORIGINAL_SENTENCE_KEY = "original_sentence";
    private String originalSentence = "";

    @Override
    public String toString() {
        return this.stream().map(x -> x.toString() + System.lineSeparator()).reduce((x, y) -> x + y).get().trim();
    }

    @Override
    public boolean add(DNode node) {
        if (node == null) {
            return false;
        }
        if (this.contains(node)) {
            return false;
        }
        node.setTree(this);
        return super.add(node);
    }

    public List<DNode> getRoots() {
        return this.padding.getChildren();
    }

    public DNode getPaddingNode() {
        return this.padding;
    }

    public UUID getUUID() {
        UUID uuid = UUID.fromString(this.padding.getFeature(UUID_KEY));
        return uuid;
    }

    public void setUUID(UUID id) {
        this.padding.addFeature(UUID_KEY, id.toString());
    }

    public String getOriginalSentence() {
        if (!this.originalSentence.trim().isEmpty()) {
            return this.originalSentence;
        }
        String originFromFeats = this.padding.getFeature(ORIGINAL_SENTENCE_KEY);
        return originFromFeats == null ? "" : originFromFeats;
    }

    public void setOriginalSentence(String originalSentence) {
        this.originalSentence = originalSentence;
        this.padding.addFeature(ORIGINAL_SENTENCE_KEY, originalSentence);
    }

    public String getSentenceType() {
        String sentenceType = this.padding.getFeature(SENTENCE_TYPE_KEY);
        return sentenceType == null ? "" : sentenceType;
    }

    public void setSentenceType(String sentenceType) {
        this.padding.addFeature(SENTENCE_TYPE_KEY, sentenceType);
    }

    public DTree() {
        this.add(this.padding);
        this.padding.setId(0);
        this.padding.setForm("^");
        this.padding.setLemma("^");
        this.padding.setcPOSTag("X");
        this.padding.setPOS("FW");
        this.padding.setDepLabel("attr");
        this.setUUID(UUID.randomUUID());
    }
}

