/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.ml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.maochen.nlp.ml.Tuple;
import org.maochen.nlp.ml.vector.LabeledVector;

public class SequenceTuple {
    public int id;
    public List<Tuple> entries;

    public SequenceTuple(Map<Integer, List<String>> featMap, List<String> tags) {
        if (featMap == null || tags == null || featMap.values().stream().findFirst().get().size() != tags.size()) {
            throw new RuntimeException("words and tags are invalid (Size mismatch).");
        }
        int[] dimensions = featMap.values().stream().mapToInt(List::size).distinct().toArray();
        if (dimensions.length != 1) {
            throw new RuntimeException("feats dimension size mismatch).");
        }
        int featIndexMax = (Integer)featMap.keySet().stream().max(Integer::compare).get();
        String[][] matrix = new String[featIndexMax + 1][];
        featMap.entrySet().forEach(entry -> {
            matrix[((Integer)entry.getKey()).intValue()] = (String[])((List)entry.getValue()).stream().toArray(String[]::new);
        });
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(dimensions[0]);
        for (int col = 0; col < dimensions[0]; ++col) {
            ArrayList<String> featString = new ArrayList<String>();
            for (int row = 0; row < matrix.length; ++row) {
                featString.add(matrix[row][col]);
            }
            LabeledVector v = new LabeledVector((String[])featString.stream().toArray(String[]::new));
            tuples.add(new Tuple(0, v, tags.get(col)));
        }
        this.entries = tuples;
    }

    public List<String> getLabel() {
        return this.entries.stream().map(x -> x.label).collect(Collectors.toList());
    }

    public SequenceTuple() {
    }
}

