/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.ml.vector;

import java.util.HashMap;
import java.util.Map;
import org.maochen.nlp.ml.vector.IVector;

public class SparseVector
implements IVector {
    private Map<Integer, Double> sparseMap = new HashMap<Integer, Double>();

    @Override
    public void setVector(double[] val) {
        for (int i = 0; i < val.length; ++i) {
            if (val[i] == 0.0) continue;
            this.sparseMap.put(i, val[i]);
        }
    }

    @Override
    public double[] getVector() {
        int maxSize = this.sparseMap.keySet().stream().mapToInt(x -> x).max().orElse(-1);
        double[] result = new double[maxSize + 1];
        for (Integer i : this.sparseMap.keySet()) {
            result[i.intValue()] = this.sparseMap.get(i);
        }
        return result;
    }
}

