/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.datastructure;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.maochen.nlp.datastructure.DTree;

public class DNode {
    private int id = 0;
    private String form = "";
    private String lemma = "";
    private String cPOSTag = "";
    private String pos = "";
    private Map<String, String> feats = new HashMap<String, String>();
    private DNode head = null;
    private String depLabel = "";
    private Map<Integer, DNode> children = new HashMap<Integer, DNode>();
    private Map<DNode, String> semanticHeads = new HashMap<DNode, String>();
    private Set<DNode> semanticChildren = new HashSet<DNode>();
    private DTree tree = null;
    public static final String NAMED_ENTITY_KEY = "name_entity";

    public DNode() {
    }

    public DNode(int id, String form, String lemma, String cPOSTag, String pos, String depLabel) {
        this();
        this.id = id;
        this.form = form;
        this.lemma = lemma;
        this.cPOSTag = cPOSTag;
        this.pos = pos;
        this.depLabel = depLabel;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public String getLemma() {
        return this.lemma;
    }

    public void setLemma(String lemma) {
        this.lemma = lemma;
    }

    public String getcPOSTag() {
        return this.cPOSTag;
    }

    public void setcPOSTag(String cPOSTag) {
        this.cPOSTag = cPOSTag;
    }

    public String getPOS() {
        return this.pos;
    }

    public void setPOS(String pos) {
        this.pos = pos;
    }

    public String getDepLabel() {
        return this.depLabel;
    }

    public void setDepLabel(String depLabel) {
        this.depLabel = depLabel;
    }

    public DNode getHead() {
        return this.head;
    }

    public void setHead(DNode head) {
        this.head = head;
    }

    public List<DNode> getChildren() {
        return this.children.values().stream().collect(Collectors.toList());
    }

    public void addChild(DNode child) {
        this.children.put(child.getId(), child);
    }

    public void removeChild(int id) {
        this.children.remove(id);
    }

    public void addFeature(String key, String value) {
        this.feats.put(key, value);
    }

    public String getFeature(String key) {
        return this.feats.get(key);
    }

    public void setFeats(Map<String, String> feats) {
        if (feats != null) {
            this.feats = feats;
        }
    }

    public Map<String, String> getFeats() {
        return this.feats;
    }

    public List<DNode> getChildrenByDepLabels(String ... labels) {
        return ((Stream)this.children.values().stream().parallel()).filter(x -> Arrays.asList(labels).contains(x.getDepLabel())).collect(Collectors.toList());
    }

    public String getNamedEntity() {
        return this.feats.get(NAMED_ENTITY_KEY) == null ? "" : this.feats.get(NAMED_ENTITY_KEY);
    }

    public void setNamedEntity(String namedEntity) {
        if (namedEntity != null) {
            this.feats.put(NAMED_ENTITY_KEY, namedEntity);
        }
    }

    public Set<DNode> getSemanticChildren() {
        return this.semanticChildren;
    }

    public void setSemanticChildren(Set<DNode> semanticChildren) {
        this.semanticChildren = semanticChildren;
    }

    public boolean isRoot() {
        return this.depLabel.equals("root");
    }

    public void addSemanticHead(DNode parent, String label) {
        this.semanticHeads.put(parent, label);
    }

    public Map<DNode, String> getSemanticHeads() {
        return this.semanticHeads;
    }

    public DTree getTree() {
        return this.tree;
    }

    public void setTree(DTree tree) {
        this.tree = tree;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id).append("\t");
        builder.append(this.form).append("\t");
        builder.append(this.lemma).append("\t");
        String cPOSTagString = this.cPOSTag.isEmpty() ? this.pos : this.cPOSTag;
        builder.append(cPOSTagString).append("\t");
        builder.append(this.pos).append("\t");
        String featsString = this.feats.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).reduce((s1, s2) -> s1 + "|" + s2).orElse("_");
        builder.append(featsString).append("\t");
        String headString = this.head == null ? "NULL" : String.valueOf(this.head.id);
        builder.append(headString).append("\t");
        builder.append(this.depLabel).append("\t");
        builder.append("_").append("\t");
        builder.append("_").append("\t");
        String semanticHeadsString = this.semanticHeads.entrySet().stream().map(e -> ((DNode)e.getKey()).getId() + ":" + (String)e.getValue()).reduce((s1, s2) -> s1 + "|" + s2).orElse("_");
        builder.append(semanticHeadsString).append("\t");
        return builder.toString().trim();
    }
}

