/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.maochen.nlp.parser.DNode;

public class DTree
extends ArrayList<DNode> {
    private DNode padding = new DNode();
    private static final String UUID_KEY = "uuid";
    private static final String SENTENCE_TYPE_KEY = "sentence_type";

    @Override
    public String toString() {
        return this.stream().map(DNode::toString).collect(Collectors.joining(System.lineSeparator())).trim();
    }

    @Override
    public boolean add(DNode node) {
        if (node == null) {
            return false;
        }
        if (this.contains(node)) {
            return false;
        }
        node.setTree(this);
        return super.add(node);
    }

    public List<DNode> getRoots() {
        return this.padding.getChildren();
    }

    public DNode getPaddingNode() {
        return this.padding;
    }

    public UUID getUUID() {
        return UUID.fromString(this.padding.getFeature(UUID_KEY));
    }

    public void setUUID(UUID id) {
        this.padding.addFeature(UUID_KEY, id.toString());
    }

    public String sentence() {
        if (!this.padding.getChildren().iterator().hasNext()) {
            return "";
        }
        if (this.padding.getChildren().iterator().next().getFeature("index_start") == null) {
            throw new RuntimeException("No idx_start, idx_end");
        }
        int lastIndex = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < this.size(); ++i) {
            DNode node = (DNode)this.get(i);
            int idxStart = Integer.parseInt(node.getFeature("index_start"));
            int idxEnd = Integer.parseInt(node.getFeature("index_end"));
            if (lastIndex + 1 == idxStart) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(node.getForm());
            lastIndex = idxEnd;
        }
        return stringBuilder.toString();
    }

    public String getSentenceType() {
        String sentenceType = this.padding.getFeature(SENTENCE_TYPE_KEY);
        return sentenceType == null ? "" : sentenceType;
    }

    public void setSentenceType(String sentenceType) {
        this.padding.addFeature(SENTENCE_TYPE_KEY, sentenceType);
    }

    public DTree() {
        this.add(this.padding);
        this.padding.setId(0);
        this.padding.setForm("^");
        this.padding.setLemma("^");
        this.padding.setcPOSTag("X");
        this.padding.setPOS("FW");
        this.padding.setDepLabel("attr");
        this.setUUID(UUID.randomUUID());
    }
}

