/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;

public class WordCount {
    private Map<String, WordDatum> wordMap = new HashMap<String, WordDatum>();
    private static Queue<WordDatum> q = new PriorityQueue<WordDatum>();
    private int totalCount = 0;
    private boolean isNormalized = false;

    public synchronized void remove(String word) {
        int prevTotalCount = this.totalCount;
        if (this.wordMap.containsKey(word)) {
            WordDatum deletedWordDatum = this.wordMap.remove(word);
            this.totalCount = (int)((double)this.totalCount - (this.isNormalized ? deletedWordDatum.getCount() * (double)this.totalCount : deletedWordDatum.getCount()));
            q.remove(deletedWordDatum);
        }
        if (this.isNormalized && prevTotalCount != this.totalCount) {
            this.reNormalize(prevTotalCount);
        }
    }

    public synchronized void put(String word) {
        WordDatum wordObject;
        if (word == null || word.isEmpty()) {
            return;
        }
        WordDatum wordDatum = wordObject = this.wordMap.containsKey(word) ? this.wordMap.get(word).addCount() : new WordDatum(word);
        if (!this.wordMap.containsKey(word)) {
            this.wordMap.put(word, wordObject);
        }
        if (q.contains(wordObject)) {
            q.remove(wordObject);
        }
        q.add(wordObject);
        ++this.totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Double> getTopX(int x) {
        if (x <= 0) {
            throw new RuntimeException("Top x is negative: " + x);
        }
        HashMap<String, Double> result = new HashMap<String, Double>();
        int i = 0;
        Queue<WordDatum> queue = q;
        synchronized (queue) {
            Iterator iter = q.iterator();
            while (iter.hasNext() && i++ < x) {
                WordDatum iterDatum = (WordDatum)iter.next();
                result.put(iterDatum.getWord(), iterDatum.getCount());
            }
        }
        return result;
    }

    public WordDatum getWordDatum(String word) {
        if (word == null || word.trim().isEmpty()) {
            return null;
        }
        return this.wordMap.containsKey(word) ? this.wordMap.get(word) : null;
    }

    public Map<String, Double> getAllWords() {
        return this.getTopX(this.wordMap.size());
    }

    private void reNormalize(double previousTotalCount) {
        for (String key : this.wordMap.keySet()) {
            double normalizedFreq = this.wordMap.get(key).getCount() * previousTotalCount / (double)this.totalCount;
            this.wordMap.get(key).setCount(normalizedFreq);
        }
    }

    public synchronized void normalize() {
        if (this.isNormalized) {
            return;
        }
        this.isNormalized = true;
        this.reNormalize(1.0);
    }

    public static void main(String[] args) {
        WordCount wordCount = new WordCount();
        wordCount.put("c");
        wordCount.put("a");
        wordCount.put("b");
        wordCount.put("b");
        wordCount.put("b");
        wordCount.put("a");
        for (int i = 0; i < 199; ++i) {
            wordCount.put("ZZ");
        }
        wordCount.normalize();
        wordCount.normalize();
        wordCount.normalize();
        System.out.println(wordCount.getAllWords());
        wordCount.remove("ZZ");
        System.out.println(wordCount.getAllWords());
    }

    static class WordDatum
    implements Comparable<WordDatum> {
        final String word;
        double count;

        public String getWord() {
            return this.word;
        }

        public void setCount(double count) {
            this.count = count;
        }

        public double getCount() {
            return this.count;
        }

        public WordDatum(String word) {
            this.word = word;
            this.count = 1.0;
            this.hashCode();
        }

        public WordDatum addCount() {
            this.count += 1.0;
            return this;
        }

        @Override
        public int compareTo(WordDatum o) {
            return Double.compare(o.count, this.count);
        }
    }
}

