/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.utils;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.maochen.nlp.utils.BiFunctionDoublePrimitive;

public class VectorUtils {
    public static Function<Double, Double> sigmoid = z -> 1.0 / (1.0 + Math.exp(-z.doubleValue()));
    public static Function<Double, Double> tanh = z -> {
        double e2z = Math.exp(2.0 * z);
        return (e2z - 1.0) / (e2z + 1.0);
    };

    public static double[] zip(double[] vec1, double[] vec2, BiFunctionDoublePrimitive op) {
        if (vec1 == null || vec2 == null) {
            return new double[0];
        }
        if (vec1.length != vec2.length) {
            throw new IllegalArgumentException("Two Vectors must has equal length.");
        }
        double[] result = new double[vec1.length];
        IntStream.range(0, vec1.length).parallel().forEach(i -> {
            dArray[i] = op.apply(vec1[i], vec2[i]);
        });
        return result;
    }

    public static double[] addition(double[] ... vectors) {
        return Arrays.stream(vectors).reduce((vec1, vec2) -> VectorUtils.zip(vec1, vec2, (f1, f2) -> f1 + f2)).orElse(null);
    }

    public static double dotProduct(double[] vec1, double[] vec2) {
        double[] result = VectorUtils.zip(vec1, vec2, (f1, f2) -> f1 * f2);
        return Arrays.stream(result).parallel().sum();
    }

    private static double vectorLen(double[] vector) {
        double len = Arrays.stream(vector).parallel().map(x -> x * x).sum();
        return Math.sqrt(len);
    }

    public static double getCosinValue(double[] vector1, double[] vector2) {
        double euclideanDistance;
        if (vector1 == null || vector2 == null) {
            return 0.0;
        }
        double dotProduct = VectorUtils.dotProduct(vector1, vector2);
        double cosineValue = Math.abs(dotProduct / (euclideanDistance = VectorUtils.vectorLen(vector1) * VectorUtils.vectorLen(vector2)));
        return cosineValue > 1.0 ? 1.0 : cosineValue;
    }

    public static double[] scale(double[] a, double scale) {
        return Arrays.stream(a).parallel().map(x -> x * scale).toArray();
    }

    public static double gaussianPDF(double mean, double variance, double x) {
        double twoVariance = 2.0 * variance;
        double probability = 1.0 / Math.sqrt(Math.PI * twoVariance);
        return probability *= Math.exp(-Math.pow(x - mean, 2.0) / twoVariance);
    }

    public static float[] doubleToFloat(double[] vector) {
        float[] result = new float[vector.length];
        IntStream.range(0, vector.length).parallel().forEach(i -> {
            fArray[i] = (float)vector[i];
        });
        return result;
    }

    public static double[] floatToDouble(float[] vector) {
        double[] result = new double[vector.length];
        IntStream.range(0, vector.length).parallel().forEach(i -> {
            dArray[i] = vector[i];
        });
        return result;
    }

    public static String[] intToString(int[] vectorIndex) {
        return (String[])Arrays.stream(vectorIndex).parallel().mapToObj(String::valueOf).toArray(String[]::new);
    }
}

