/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.classifier.knn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maochen.nlp.classifier.IClassifier;
import org.maochen.nlp.classifier.knn.KNNEngine;
import org.maochen.nlp.datastructure.Tuple;

public class KNNClassifier
implements IClassifier {
    private List<Tuple> trainingData;
    private int k = 1;
    private int mode = 0;

    @Override
    public void setParameter(Map<String, String> paraMap) {
        if (paraMap.containsKey("k")) {
            this.k = Integer.parseInt(paraMap.get("k"));
        }
        if (paraMap.containsKey("mode")) {
            this.mode = Integer.parseInt(paraMap.get("mode"));
        }
    }

    @Override
    public IClassifier train(List<Tuple> trainingData) {
        this.trainingData = trainingData;
        return this;
    }

    @Override
    public Map<String, Double> predict(Tuple predict) {
        KNNEngine engine = new KNNEngine(predict, this.trainingData, this.k);
        if (this.mode == 1) {
            engine.getDistance(engine.chebyshevDistance);
        } else if (this.mode == 2) {
            engine.getDistance(engine.manhattanDistance);
        } else {
            engine.getDistance(engine.euclideanDistance);
        }
        predict.label = engine.getResult();
        ConcurrentHashMap<String, Double> outputMap = new ConcurrentHashMap<String, Double>();
        this.trainingData.parallelStream().forEach(x -> outputMap.put(String.valueOf(x.id), x.distance));
        return outputMap;
    }

    public static void main(String[] args) {
        int k = 3;
        Tuple vectorA = new Tuple(1, new double[]{9.0, 32.0, 65.1}, "A");
        Tuple vectorB = new Tuple(2, new double[]{12.0, 65.0, 86.1}, "C");
        Tuple vectorC = new Tuple(3, new double[]{19.0, 54.0, 45.1}, "C");
        ArrayList<Tuple> trainList = new ArrayList<Tuple>();
        trainList.add(vectorA);
        trainList.add(vectorB);
        trainList.add(vectorC);
        Tuple predict = new Tuple(new double[]{74.0, 55.0, 22.0});
        KNNClassifier knn = new KNNClassifier();
        knn.train(trainList);
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("k", String.valueOf(k));
        System.out.println("Euclidean Distance:");
        paraMap.put("mode", "0");
        knn.setParameter(paraMap);
        Map<String, Double> details = knn.predict(predict);
        System.out.println("Prediction data: " + predict);
        System.out.println(details);
        System.out.println();
        System.out.println("Chebyshev Distance:");
        paraMap.put("mode", "1");
        knn.setParameter(paraMap);
        details = knn.predict(predict);
        System.out.println("Prediction data: " + predict);
        System.out.println(details);
        System.out.println();
        System.out.println("Manhattan Distance:");
        paraMap.put("mode", "2");
        knn.setParameter(paraMap);
        details = knn.predict(predict);
        System.out.println("Prediction data: " + predict);
        System.out.println(details);
    }
}

