/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.datastructure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DoubleKeyMap<K1, K2, V>
implements Serializable {
    private Map<K1, Map<K2, V>> data = new HashMap<K1, Map<K2, V>>();
    private Map<K2, Set<K1>> k2Cache = new HashMap<K2, Set<K1>>();

    public void clear() {
        this.data = new HashMap<K1, Map<K2, V>>();
        this.k2Cache = new HashMap<K2, Set<K1>>();
    }

    public boolean containsKey1(K1 k1) {
        return this.data.containsKey(k1);
    }

    public boolean containsKey2(K2 k2) {
        return this.k2Cache.containsKey(k2);
    }

    public boolean containsValue(V value) {
        for (K1 key1 : this.data.keySet()) {
            for (K2 key2 : this.data.get(key1).keySet()) {
                V fetchedValue = this.data.get(key1).get(key2);
                if (!fetchedValue.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public Map<K2, V> row(K1 key1) {
        if (!this.data.containsKey(key1)) {
            return null;
        }
        return this.data.get(key1);
    }

    public Map<K1, V> column(K2 key2) {
        if (!this.k2Cache.containsKey(key2)) {
            return null;
        }
        HashMap<K1, V> result = new HashMap<K1, V>();
        Set<K1> k1Set = this.k2Cache.get(key2);
        for (K1 key1 : k1Set) {
            result.put(key1, this.data.get(key1).get(key2));
        }
        return result;
    }

    public V get(K1 key1, K2 key2) {
        if (key1 == null || key2 == null) {
            throw new RuntimeException("[DoubleKeyMap.key] Please fill all keys.");
        }
        return this.data.get(key1).get(key2);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public V put(K1 key1, K2 key2, V value) {
        if (key1 == null || key2 == null || value == null) {
            throw new RuntimeException("[DoubleKeyMap.put] Please fill all keys and value.");
        }
        HashMap<K2, V> entry = this.data.containsKey(key1) ? this.data.get(key1) : new HashMap<K2, V>();
        entry.put(key2, value);
        this.data.put(key1, entry);
        HashSet<K1> k2CacheK1Set = this.k2Cache.containsKey(key2) ? this.k2Cache.get(key2) : new HashSet<K1>();
        k2CacheK1Set.add(key1);
        this.k2Cache.put(key2, k2CacheK1Set);
        return value;
    }

    public V remove(K1 key1, K2 key2) {
        Map<K2, V> entry;
        if (key1 == null || key2 == null) {
            throw new RuntimeException("[DoubleKeyMap.remove] Please fill all keys.");
        }
        V removedObject = null;
        boolean isValueExisted = false;
        if (this.data.containsKey(key1) && (entry = this.data.get(key1)).containsKey(key2)) {
            isValueExisted = true;
        }
        if (isValueExisted) {
            entry = this.data.get(key1);
            removedObject = entry.remove(key2);
            this.k2Cache.get(key2).remove(key1);
        }
        return removedObject;
    }

    public Map<K2, V> removeK1(K1 key1) {
        Set<K2> key2List = this.data.get(key1).keySet();
        for (K2 key2 : key2List) {
            this.k2Cache.get(key2).remove(key1);
        }
        return this.data.remove(key1);
    }

    public Map<K1, V> removeK2(K2 key2) {
        HashMap<K1, V> result = new HashMap<K1, V>();
        Set<K1> key1List = this.k2Cache.get(key2);
        for (K1 key1 : key1List) {
            result.put(key1, this.data.get(key1).remove(key2));
        }
        this.k2Cache.remove(key2);
        return result;
    }

    public Set<K1> rowKeySet() {
        return this.data.keySet();
    }

    public Set<K2> key2Set() {
        return this.k2Cache.keySet();
    }

    public int size() {
        int size = 0;
        for (K1 key1 : this.data.keySet()) {
            size += this.data.get(key1).keySet().size();
        }
        return size;
    }

    public String toString() {
        ArrayList<String> str = new ArrayList<String>();
        for (K1 key1 : this.data.keySet()) {
            for (K2 key2 : this.data.get(key1).keySet()) {
                String formattedStr = "[" + key1 + ", " + key2 + "]=" + this.data.get(key1).get(key2) + "\n";
                str.add(formattedStr);
            }
        }
        return ((Object)str).toString();
    }
}

