/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.sentencetypeclassifier;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Scanner;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.DataStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.RealBasicEventStream;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.AbstractModel;
import opennlp.model.EventStream;
import opennlp.model.RealValueFileEventStream;
import org.maochen.nlp.sentencetypeclassifier.FeatureExtractor;
import org.maochen.nlp.sentencetypeclassifier.TrainingFeatureExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentenceTypeClassifier {
    private static final Logger LOG = LoggerFactory.getLogger(SentenceTypeClassifier.class);
    public static final String DELIMITER = " ";
    private static final boolean USE_SMOOTHING = true;
    private static final int ITERATIONS = 100;
    private static final int CUTOFF = 0;
    private String filepathPrefix;
    private GISModel model;
    private boolean isRealFeature = false;

    public void train(String trainFilePath, TrainingFeatureExtractor trainingFeatureExtractor) throws IOException {
        HashSet<String> trainingData = new HashSet<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(trainFilePath));){
            String line = br.readLine();
            while (line != null) {
                trainingData.add(line);
                line = br.readLine();
            }
        }
        this.isRealFeature = trainingFeatureExtractor.isRealFeature;
        trainingFeatureExtractor.extractFeature(trainingData);
        Object es = this.isRealFeature ? new RealBasicEventStream((DataStream)new PlainTextByLineDataStream((Reader)new FileReader(this.filepathPrefix + "/featureVector.txt"))) : new BasicEventStream((DataStream)new PlainTextByLineDataStream((Reader)new FileReader(this.filepathPrefix + "/featureVector.txt")));
        this.model = GIS.trainModel((EventStream)es, (int)100, (int)0, (boolean)true, (boolean)true);
    }

    public void persist(String modelPath) throws IOException {
        File outputFile = new File(modelPath);
        SuffixSensitiveGISModelWriter writer = new SuffixSensitiveGISModelWriter((AbstractModel)this.model, outputFile);
        writer.persist();
    }

    public void loadModel(String modelPath) throws IOException {
        long start = System.currentTimeMillis();
        LOG.info("Loading MaxEnt model ... ");
        this.model = (GISModel)new SuffixSensitiveGISModelReader(new File(modelPath)).getModel();
        long end = System.currentTimeMillis();
        long duration = (end - start) / 1000L;
        LOG.info("completed ... " + duration + " secs.");
    }

    private double[] predictOCS(String sentence, FeatureExtractor featureExtractor) {
        double[] ocs;
        sentence = sentence.replaceAll("\\s+", "_");
        String vector = featureExtractor.getFeats(sentence + DELIMITER + "?");
        String[] contexts = vector.split(DELIMITER);
        if (this.isRealFeature) {
            float[] values = RealValueFileEventStream.parseContexts((String[])contexts);
            ocs = this.model.eval(contexts, values);
        } else {
            ocs = this.model.eval(contexts);
        }
        return ocs;
    }

    public String predict(String sentence, FeatureExtractor featureExtractor) {
        return this.model.getBestOutcome(this.predictOCS(sentence, featureExtractor));
    }

    public String predictAllOutcome(String sentence, FeatureExtractor featureExtractor) {
        return this.model.getAllOutcomes(this.predictOCS(sentence, featureExtractor));
    }

    public SentenceTypeClassifier(String filepathPrefix) {
        this.filepathPrefix = filepathPrefix;
    }

    public static void annotate(String testFilePath, SentenceTypeClassifier sentenceTypeClassifier, FeatureExtractor featureExtractor) {
        try (BufferedReader br = new BufferedReader(new FileReader(testFilePath));){
            BufferedWriter bw = new BufferedWriter(new FileWriter(testFilePath + ".result"));
            String line = br.readLine();
            while (line != null) {
                String result = sentenceTypeClassifier.predict(line, featureExtractor);
                bw.write(line.replaceAll("\\s", "_") + DELIMITER + result + System.getProperty("line.separator"));
                line = br.readLine();
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        String sentence;
        String prefix = "/Users/Maochen/Desktop/temp";
        String trainFilePath = SentenceTypeClassifier.class.getResource("/sentence_type_corpus.txt").getPath();
        String modelPath = prefix + "/model.dat";
        SentenceTypeClassifier sentenceTypeClassifier = new SentenceTypeClassifier(prefix);
        TrainingFeatureExtractor trainingFeatureExtractor = new TrainingFeatureExtractor(prefix, DELIMITER);
        sentenceTypeClassifier.train(trainFilePath, trainingFeatureExtractor);
        sentenceTypeClassifier.persist(modelPath);
        TrainingFeatureExtractor featureExtractor = trainingFeatureExtractor;
        sentenceTypeClassifier.loadModel(modelPath);
        Scanner scanner = new Scanner(System.in);
        System.out.println("Input Sentence:");
        while (!(sentence = scanner.nextLine()).equalsIgnoreCase("exit")) {
            sentence = sentence.replaceAll("\\s", "_");
            String vector = featureExtractor.getFeats(sentence + DELIMITER + "?");
            System.out.println(vector);
            String result = sentenceTypeClassifier.predictAllOutcome(sentence, featureExtractor);
            System.out.println(result + " ||| " + sentenceTypeClassifier.predict(sentence, featureExtractor));
        }
        scanner.close();
        System.exit(0);
    }
}

