/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.ml.classifier.naivebayes;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.maochen.nlp.ml.IClassifier;
import org.maochen.nlp.ml.Tuple;
import org.maochen.nlp.ml.classifier.naivebayes.NBTrainingEngine;
import org.maochen.nlp.ml.classifier.naivebayes.NaiveBayesModel;
import org.maochen.nlp.ml.vector.DenseVector;
import org.maochen.nlp.ml.vector.IVector;
import org.maochen.nlp.utils.VectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaiveBayesClassifier
implements IClassifier {
    private static final Logger LOG = LoggerFactory.getLogger(NaiveBayesClassifier.class);
    private NaiveBayesModel model;

    public NaiveBayesClassifier(InputStream modelInputStream) {
        this.model = new NaiveBayesModel();
        this.model.load(modelInputStream);
    }

    public NaiveBayesClassifier() {
    }

    public void setParameter(Map<String, String> paraMap) {
        throw new NotImplementedException("No parameter needed for Naive Bayes.");
    }

    public Map<String, Double> predict(Tuple predict) {
        HashMap<Integer, Double> labelProb = new HashMap<Integer, Double>();
        for (Integer labelIndex : this.model.labelIndexer.getIndexSet()) {
            double likelihood = 1.0;
            for (int i = 0; i < predict.vector.getVector().length; ++i) {
                double fi = predict.vector.getVector()[i];
                likelihood *= VectorUtils.gaussianPDF(this.model.meanVectors[labelIndex][i], this.model.varianceVectors[labelIndex][i], fi);
            }
            double posterior = this.model.labelPrior.get(labelIndex) * likelihood;
            labelProb.put(labelIndex, posterior);
        }
        double evidence = labelProb.values().stream().reduce((e1, e2) -> e1 + e2).orElse(-1.0);
        if (evidence == -1.0) {
            LOG.error("Evidence is Empty!");
            return new HashMap<String, Double>();
        }
        labelProb.entrySet().forEach(entry -> {
            double prob = (Double)entry.getValue() / evidence;
            labelProb.put((Integer)entry.getKey(), prob);
        });
        Map<String, Double> result = this.model.labelIndexer.convertMapKey(labelProb);
        if (predict.label == null || predict.label.isEmpty()) {
            predict.label = result.entrySet().stream().max((e1, e2) -> ((Double)e1.getValue()).compareTo((Double)e2.getValue())).map(Map.Entry::getKey).orElse("");
        }
        return result;
    }

    public String predictLabel(Tuple predict) {
        Map<String, Double> prob = this.predict(predict);
        return prob.entrySet().stream().max((x1, x2) -> ((Double)x1.getValue()).compareTo((Double)x2.getValue())).map(Map.Entry::getKey).orElse(null);
    }

    public IClassifier train(List<Tuple> trainingData) {
        this.model = new NBTrainingEngine(trainingData).train();
        return this;
    }

    public void persistModel(String filename) {
        if (this.model != null) {
            this.model.persist(filename);
        }
    }

    public void loadModel(InputStream inputStream) {
        this.model = new NaiveBayesModel();
        this.model.load(inputStream);
    }

    public static List<Tuple> readTrainingData(String filename, String delimiter) {
        ArrayList<Tuple> data = new ArrayList<Tuple>();
        List<Object> trainingDataString = new ArrayList();
        try {
            Throwable throwable = null;
            try (BufferedReader br = new BufferedReader(new FileReader(filename));){
                String line = br.readLine();
                while (line != null) {
                    trainingDataString.add(line.trim());
                    line = br.readLine();
                }
            }
            catch (Throwable line) {
                Throwable throwable2 = line;
                throw line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        trainingDataString = trainingDataString.parallelStream().distinct().collect(Collectors.toList());
        for (String string : trainingDataString) {
            String[] tokens = string.trim().split(delimiter);
            String label = tokens[0];
            double[] values = new double[tokens.length - 1];
            for (int i = 1; i < tokens.length; ++i) {
                String tokenString = tokens[i].contains(":") ? tokens[i].split(":")[1] : tokens[i];
                values[i - 1] = Double.parseDouble(tokenString);
            }
            data.add(new Tuple(0, (IVector)new DenseVector(values), label));
        }
        return data;
    }

    public static void writeToFile(List<Tuple> dataset, String filename) {
        try (BufferedWriter output = new BufferedWriter(new FileWriter(new File(filename)));){
            for (Tuple t : dataset) {
                output.write(t.toString() + System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void splitData(String originalTrainingDataFile) {
        int lastTrainingDataSize;
        List<Tuple> trainingData = NaiveBayesClassifier.readTrainingData(originalTrainingDataFile, "\\s");
        ArrayList<Tuple> wrongData = new ArrayList<Tuple>();
        int iterCount = 0;
        do {
            System.out.println("Iteration:\t" + ++iterCount);
            lastTrainingDataSize = trainingData.size();
            NaiveBayesClassifier nbc = new NaiveBayesClassifier();
            nbc.train(trainingData);
            Iterator<Tuple> trainingDataIter = trainingData.iterator();
            while (trainingDataIter.hasNext()) {
                Tuple t = trainingDataIter.next();
                String actual = nbc.predictLabel(t);
                if (t.label.equals(actual) || t.label.equals("1")) continue;
                wrongData.add(t);
                trainingDataIter.remove();
            }
            Iterator wrongDataIter = wrongData.iterator();
            while (wrongDataIter.hasNext()) {
                Tuple t = (Tuple)wrongDataIter.next();
                String actual = nbc.predictLabel(t);
                if (!t.label.equals(actual)) continue;
                trainingData.add(t);
                wrongDataIter.remove();
            }
        } while (trainingData.size() != lastTrainingDataSize);
        NaiveBayesClassifier.writeToFile(trainingData, originalTrainingDataFile + ".aligned");
        NaiveBayesClassifier.writeToFile(wrongData, originalTrainingDataFile + ".wrong");
    }
}

