/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.ml.classifier.naivebayes;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.maochen.nlp.ml.classifier.LabelIndexer;
import org.maochen.nlp.ml.classifier.utils.ModelSerializeUtils;

public class NaiveBayesModel {
    double[][] meanVectors;
    double[][] varianceVectors;
    LabelIndexer labelIndexer;
    Map<Integer, Double> labelPrior;

    public void persist(String filename) {
        try (BufferedWriter output = new BufferedWriter(new FileWriter(new File(filename)));){
            output.write(ModelSerializeUtils.twoDimensionalArraySerialize(this.meanVectors));
            output.write(System.lineSeparator());
            output.write(ModelSerializeUtils.twoDimensionalArraySerialize(this.varianceVectors));
            output.write(System.lineSeparator());
            output.write(ModelSerializeUtils.mapSerialize(this.labelIndexer.labelIndexer.entrySet()));
            output.write(System.lineSeparator());
            output.write(ModelSerializeUtils.mapSerialize(this.labelPrior.entrySet()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(InputStream is) {
        this.labelIndexer = new LabelIndexer(Lists.newArrayList());
        this.labelPrior = new HashMap<Integer, Double>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            int newItemCount = 0;
            boolean isFirstLine = true;
            int row = 0;
            while ((line = br.readLine()) != null) {
                String[] values;
                String[] args;
                if (line.trim().isEmpty()) {
                    isFirstLine = true;
                    ++newItemCount;
                    continue;
                }
                if (newItemCount == 0) {
                    if (isFirstLine) {
                        isFirstLine = false;
                        args = line.split("\\s");
                        this.meanVectors = new double[Integer.parseInt(args[0])][Integer.parseInt(args[1])];
                        row = 0;
                        continue;
                    }
                    values = line.split("\\s");
                    this.meanVectors[row] = Arrays.stream(values).map(Double::parseDouble).mapToDouble(x -> x).toArray();
                    ++row;
                    continue;
                }
                if (newItemCount == 1) {
                    if (isFirstLine) {
                        isFirstLine = false;
                        args = line.split("\\s");
                        this.varianceVectors = new double[Integer.parseInt(args[0])][Integer.parseInt(args[1])];
                        row = 0;
                        continue;
                    }
                    values = line.split("\\s");
                    this.varianceVectors[row] = Arrays.stream(values).map(Double::parseDouble).mapToDouble(x -> x).toArray();
                    ++row;
                    continue;
                }
                if (newItemCount == 2) {
                    this.labelIndexer.labelIndexer.put((Object)line.split("\\s")[0], (Object)Integer.parseInt(line.split("\\s")[1]));
                    continue;
                }
                if (newItemCount != 3) continue;
                this.labelPrior.put(Integer.parseInt(line.split("\\s")[0]), Double.parseDouble(line.split("\\s")[1]));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

