/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.sentencetype;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.maochen.nlp.parser.DNode;
import org.maochen.nlp.parser.DTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureExtractor.class);

    public List<String> generateFeats(String sentence, DTree tree) {
        DNode whether;
        HashSet imperativeKeywords;
        boolean isImperativeStart;
        int auxCount;
        ArrayList<String> feats = new ArrayList<String>();
        feats.add("first_word_pos_" + ((DNode)tree.get(1)).getPOS());
        DNode lastWord = ((DNode)tree.get(tree.size() - 1)).getDepLabel().equals("punct") ? (DNode)tree.get(tree.size() - 2) : (DNode)tree.get(tree.size() - 1);
        feats.add("last_word_pos_" + lastWord.getPOS());
        if (((DNode)tree.get(tree.size() - 1)).getDepLabel().equals("punct")) {
            feats.add("punct_" + ((DNode)tree.get(tree.size() - 1)).getLemma());
        }
        if (tree.getRoots().contains(tree.get(1))) {
            feats.add("first_word_root");
        }
        if ((auxCount = (int)((Stream)tree.stream().parallel()).filter(x -> "aux".equals(x.getDepLabel())).distinct().count()) > 0) {
            feats.add("has_aux_verb");
        }
        boolean bl = isImperativeStart = (imperativeKeywords = Sets.newHashSet((Object[])new String[]{"verify", "ask", "say", "solve", "run", "execute"})).contains(((DNode)tree.get(1)).getLemma()) && ((DNode)tree.get(1)).isRoot();
        if (isImperativeStart) {
            feats.add("imperative_start");
        }
        if ((whether = (DNode)tree.stream().filter(x -> "whether".equals(x.getLemma())).findFirst().orElse(null)) != null) {
            feats.add("has_whether");
        }
        HashSet bagOfQuestionPrefix = Sets.newHashSet((Object[])new String[]{"tell me", "let me know", "clarify for me", "name"});
        boolean isStartPrefixMatch = false;
        for (String prefix : bagOfQuestionPrefix) {
            if (!sentence.toLowerCase().startsWith(prefix)) continue;
            isStartPrefixMatch = true;
            break;
        }
        if (isStartPrefixMatch) {
            feats.add("question_bow_head");
        }
        ArrayList<String> biWord = new ArrayList<String>();
        ArrayList<String> biDep = new ArrayList<String>();
        ArrayList<String> triWord = new ArrayList<String>();
        ArrayList<String> triDep = new ArrayList<String>();
        for (int i = 1; i < tree.size(); ++i) {
            DNode nextNode;
            DNode node = (DNode)tree.get(i);
            if (tree.getPaddingNode() == node) continue;
            if (i + 1 < tree.size()) {
                nextNode = (DNode)tree.get(i + 1);
                biWord.add(node.getForm().toLowerCase() + "_" + nextNode.getForm().toLowerCase());
                biDep.add(node.getDepLabel() + "_" + nextNode.getDepLabel());
            }
            if (i + 2 >= tree.size()) continue;
            nextNode = (DNode)tree.get(i + 1);
            DNode nextNextNode = (DNode)tree.get(i + 2);
            triWord.add(node.getForm().toLowerCase() + "_" + nextNode.getForm().toLowerCase() + "_" + nextNextNode.getForm().toLowerCase());
            triDep.add(node.getDepLabel() + "_" + nextNode.getDepLabel() + "_" + nextNextNode.getDepLabel());
        }
        feats.addAll(biWord);
        feats.addAll(biDep);
        feats.addAll(triWord);
        feats.addAll(triDep);
        return feats;
    }
}

