/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.app.relationextract;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import org.maochen.nlp.app.relationextract.RelType;
import org.maochen.nlp.commons.BinRelation;
import org.maochen.nlp.commons.Entity;
import org.maochen.nlp.parser.DNode;
import org.maochen.nlp.parser.DTree;
import org.maochen.nlp.parser.stanford.nn.StanfordNNDepParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionRelationExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(QuestionRelationExtractor.class);

    private static Set<DNode> bfs(DNode root) {
        HashSet<DNode> result = new HashSet<DNode>();
        LinkedList<DNode> q = new LinkedList<DNode>();
        q.add(root);
        while (!q.isEmpty()) {
            DNode current = (DNode)q.poll();
            result.add(current);
            q.addAll(current.getChildren());
        }
        return result;
    }

    private static Entity<DNode> extractRemaining(DNode wildcardNode, DNode wildcardHeadVerb, DTree tree) {
        Set remain = wildcardHeadVerb.getChildren().stream().filter(x -> x != wildcardNode).collect(Collectors.toSet());
        Set children = remain.stream().map(QuestionRelationExtractor::bfs).flatMap(Collection::stream).collect(Collectors.toSet());
        remain.addAll(children);
        ImmutableSet excludingLabels = ImmutableSet.of((Object)"aux", (Object)"auxpass");
        remain = remain.stream().filter(arg_0 -> QuestionRelationExtractor.lambda$extractRemaining$77((Set)excludingLabels, arg_0)).collect(Collectors.toSet());
        remain.remove(tree.get(tree.size() - 1));
        Entity entity = new Entity();
        entity.addAll((Collection)remain.stream().sorted((x1, x2) -> Integer.compare(x1.getId(), x2.getId())).collect(Collectors.toList()));
        return entity;
    }

    private static Entity<DNode> getWildcardEntity(DNode wildcardNode, String questionType) {
        Entity wildcardEntity = new Entity((Object)wildcardNode);
        wildcardEntity.suggestedName = "?X";
        wildcardEntity.feats.put("question_type", questionType);
        return wildcardEntity;
    }

    private static BinRelation extractNonPolar(DTree tree, String questionType) {
        DNode wildcardHeadVerb;
        if (tree == null) {
            return null;
        }
        DNode wildcardNode = tree.stream().filter(x -> x.getPOS().toLowerCase().startsWith("w")).findFirst().orElse(null);
        if (wildcardNode == null) {
            LOG.warn("Unable to find wildcard node.");
            return null;
        }
        for (wildcardHeadVerb = wildcardNode; wildcardHeadVerb != null && !wildcardHeadVerb.getPOS().startsWith("VB"); wildcardHeadVerb = wildcardHeadVerb.getHead()) {
        }
        if (wildcardHeadVerb == null) {
            LOG.warn("Unable to find verb for wildcard node [" + wildcardNode.getForm() + "]");
            return null;
        }
        BinRelation wildcardRel = new BinRelation();
        wildcardRel.setLeft(QuestionRelationExtractor.getWildcardEntity(wildcardNode, questionType));
        wildcardRel.setRel(wildcardHeadVerb.getLemma());
        wildcardRel.relType = RelType.WILDCARD.toString();
        wildcardRel.setRight(QuestionRelationExtractor.extractRemaining(wildcardNode, wildcardHeadVerb, tree));
        return wildcardRel;
    }

    private static BinRelation extractPolar(DTree tree) {
        DNode rootVerb = (DNode)tree.getRoots().get(0);
        BinRelation binRelation = new BinRelation();
        return binRelation;
    }

    public static BinRelation extract(DTree tree, String qt) {
        if (qt.equals("YESNO")) {
            return QuestionRelationExtractor.extractPolar(tree);
        }
        return QuestionRelationExtractor.extractNonPolar(tree, qt);
    }

    public static void main(String[] args) {
        StanfordNNDepParser parser = new StanfordNNDepParser();
        DTree question = parser.parse("What is meant by an expense?");
        System.out.println(question);
        BinRelation rel = QuestionRelationExtractor.extract(question, "XXX");
        System.out.println(rel);
    }

    private static /* synthetic */ boolean lambda$extractRemaining$77(Set excludingLabels, DNode x) {
        return !excludingLabels.contains(x.getDepLabel());
    }
}

