/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.parser.stanford.coref;

import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.maochen.nlp.parser.stanford.coref.CorefAnnotator;
import org.maochen.nlp.parser.stanford.pcfg.StanfordPCFGParser;

public class StanfordCoref {
    private static CorefAnnotator corefAnnotator = new CorefAnnotator();
    private static StanfordPCFGParser parser;

    public Pair<List<CoreMap>, Map<Integer, CorefChain>> getCorefChain(List<String> texts) {
        List<Pair<CoreMap, GrammaticalStructure>> sentencesWithGS = texts.stream().filter(x -> !x.trim().isEmpty()).map(parser::parseForCoref).collect(Collectors.toList());
        Map<Integer, CorefChain> corefChainMap = corefAnnotator.annotate(sentencesWithGS);
        List sentences = sentencesWithGS.stream().map(Pair::getLeft).collect(Collectors.toList());
        return new ImmutablePair(sentences, corefChainMap);
    }

    public List<String> getCoref(List<String> texts) {
        Pair<List<CoreMap>, Map<Integer, CorefChain>> result = this.getCorefChain(texts);
        List sentences = (List)result.getLeft();
        Map corefChainMap = (Map)result.getRight();
        for (Integer clusterID : corefChainMap.keySet()) {
            List realEntities;
            List mentions = ((CorefChain)corefChainMap.get(clusterID)).getMentionsInTextualOrder();
            if (mentions.size() < 2 || (realEntities = mentions.stream().filter(x -> !x.mentionType.equals((Object)Dictionaries.MentionType.PRONOMINAL)).map(x -> x.mentionSpan).collect(Collectors.toList())).isEmpty()) continue;
            mentions.stream().filter(x -> x.mentionType.equals((Object)Dictionaries.MentionType.PRONOMINAL)).forEach(mention -> {
                List sentence = (List)((CoreMap)sentences.get(mention.sentNum - 1)).get(CoreAnnotations.TokensAnnotation.class);
                ((CoreLabel)sentence.get(mention.startIndex - 1)).setWord((String)realEntities.get(0));
                for (int i = mention.startIndex; i < mention.endIndex - 1; ++i) {
                    ((CoreLabel)sentence.get(i)).setWord("");
                }
            });
        }
        return sentences.stream().map(sentence -> ((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).stream().map(CoreLabel::word).reduce((w1, w2) -> w1 + " " + w2).get()).collect(Collectors.toList());
    }

    public StanfordCoref(StanfordPCFGParser parser) {
        StanfordCoref.parser = parser;
    }
}

