/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.app.chunker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.maochen.nlp.ml.SequenceTuple;
import org.maochen.nlp.ml.Tuple;
import org.maochen.nlp.ml.vector.IVector;
import org.maochen.nlp.ml.vector.LabeledVector;

public class ChunkerFeatureExtractor {
    private static void addFeat(Set<String> feat, String key, String ... val) {
        String entry = Arrays.stream(val).reduce((v1, v2) -> v1 + "_" + v2).get();
        entry = key + "=" + entry;
        feat.add(entry);
    }

    public static Set<String> extractFeatSingle(int i, String[] tokens, String[] pos, String[] resolvedPrevTags) {
        HashSet<String> currentFeats = new HashSet<String>();
        ChunkerFeatureExtractor.addFeat(currentFeats, "w0", tokens[i]);
        ChunkerFeatureExtractor.addFeat(currentFeats, "pos0", pos[i]);
        if (i > 0) {
            ChunkerFeatureExtractor.addFeat(currentFeats, "tag-1", resolvedPrevTags[i - 1]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos-1tag-1pos0", pos[i - 1], resolvedPrevTags[i - 1], pos[i]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "w-1", tokens[i - 1]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos-1", pos[i - 1]);
        }
        if (i > 1) {
            ChunkerFeatureExtractor.addFeat(currentFeats, "tag-2", resolvedPrevTags[i - 2]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "tag-2-1pos0", resolvedPrevTags[i - 2], resolvedPrevTags[i - 1], pos[i]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos-2", pos[i - 2]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos-2-1", pos[i - 2], pos[i - 1]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos-20", pos[i - 2], pos[i]);
        }
        if (i > 2) {
            ChunkerFeatureExtractor.addFeat(currentFeats, "tag-3", resolvedPrevTags[i - 3]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "tag-3-2-1pos0", resolvedPrevTags[i - 3], resolvedPrevTags[i - 2], resolvedPrevTags[i - 1], pos[i]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos-3", pos[i - 3]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos-30", pos[i - 3], pos[i]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos-3-2", pos[i - 3], pos[i - 2]);
        }
        if (i < tokens.length - 1) {
            ChunkerFeatureExtractor.addFeat(currentFeats, "w+1", tokens[i + 1]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos+1", pos[i + 1]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos0+1", pos[i], pos[i + 1]);
        }
        if (i < tokens.length - 2) {
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos+2", pos[i + 2]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos0+2", pos[i], pos[i + 2]);
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos0+1+2", pos[i], pos[i + 1], pos[i + 2]);
        }
        if (i > 0 && i < tokens.length - 1) {
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos-10+1", pos[i - 1], pos[i], pos[i + 1]);
        }
        if (i > 1 && i < tokens.length - 1) {
            ChunkerFeatureExtractor.addFeat(currentFeats, "pos-2-10+1", pos[i - 2], pos[i - 1], pos[i], pos[i + 1]);
        }
        return currentFeats;
    }

    public static List<Tuple> extractFeat(SequenceTuple entry) {
        String[] tokens = (String[])entry.entries.stream().map(tuple -> ((LabeledVector)tuple.vector).featsName[0]).toArray(String[]::new);
        String[] pos = (String[])entry.entries.stream().map(tuple -> ((LabeledVector)tuple.vector).featsName[1]).toArray(String[]::new);
        List feats = IntStream.range(0, tokens.length).mapToObj(i -> ChunkerFeatureExtractor.extractFeatSingle(i, tokens, pos, (String[])entry.tag.stream().toArray(String[]::new))).collect(Collectors.toList());
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (int i2 = 0; i2 < feats.size(); ++i2) {
            Set singleTokenFeat = (Set)feats.get(i2);
            LabeledVector v = new LabeledVector((String[])singleTokenFeat.stream().toArray(String[]::new));
            Tuple t = new Tuple((IVector)v);
            t.label = (String)entry.tag.get(i2);
            tuples.add(t);
        }
        return tuples;
    }

    public static List<Tuple> extract(Set<SequenceTuple> trainingData) {
        if (trainingData == null) {
            return null;
        }
        return trainingData.parallelStream().map(ChunkerFeatureExtractor::extractFeat).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

