/*
 * Decompiled with CFR 0.152.
 */
package org.maochen.nlp.parser.stanford.coref;

import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.MentionExtractor;
import edu.stanford.nlp.dcoref.RuleBasedCorefMentionFinder;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class CorefAnnotator {
    private static final boolean VERBOSE = false;
    private final MentionExtractor mentionExtractor;
    private final SieveCoreferenceSystem corefSystem;
    private final boolean allowReparsing;

    public CorefAnnotator() {
        Properties props = new Properties();
        try {
            this.corefSystem = new SieveCoreferenceSystem(props);
            this.mentionExtractor = new MentionExtractor(this.corefSystem.dictionaries(), this.corefSystem.semantics());
            this.allowReparsing = false;
        }
        catch (Exception e) {
            System.err.println("ERROR: cannot create CorefAnnotator!");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Map<Integer, CorefChain> annotate(List<Pair<CoreMap, GrammaticalStructure>> annotatedSentences) {
        Map result = null;
        ArrayList<List> sentences = new ArrayList<List>();
        boolean hasSpeakerAnnotations = false;
        for (Pair<CoreMap, GrammaticalStructure> sentence : annotatedSentences) {
            List tokens = (List)((CoreMap)sentence.getLeft()).get(CoreAnnotations.TokensAnnotation.class);
            sentences.add(tokens);
            GrammaticalStructure gs = (GrammaticalStructure)sentence.getRight();
            SemanticGraph dependencies = SemanticGraphFactory.makeFromTree((GrammaticalStructure)gs, (SemanticGraphFactory.Mode)SemanticGraphFactory.Mode.COLLAPSED, (GrammaticalStructure.Extras)GrammaticalStructure.Extras.NONE, (boolean)true, s -> true);
            ((CoreMap)sentence.getLeft()).set(SemanticGraphCoreAnnotations.AlternativeDependenciesAnnotation.class, (Object)dependencies);
            if (!hasSpeakerAnnotations) {
                for (CoreLabel t : tokens) {
                    if (t.get(CoreAnnotations.SpeakerAnnotation.class) == null) continue;
                    hasSpeakerAnnotations = true;
                    break;
                }
            }
            MentionExtractor.initializeUtterance((List)tokens);
        }
        Annotation annotation = new Annotation(annotatedSentences.stream().map(Pair::getLeft).collect(Collectors.toList()));
        if (hasSpeakerAnnotations) {
            annotation.set(CoreAnnotations.UseMarkedDiscourseAnnotation.class, (Object)true);
        }
        RuleBasedCorefMentionFinder finder = new RuleBasedCorefMentionFinder(this.allowReparsing);
        List allUnprocessedMentions = finder.extractPredictedMentions(annotation, 0, this.corefSystem.dictionaries());
        try {
            List trees = annotatedSentences.stream().map(x -> (Tree)((CoreMap)x.getLeft()).get(TreeCoreAnnotations.TreeAnnotation.class)).collect(Collectors.toList());
            Document document = this.mentionExtractor.arrange(annotation, sentences, trees, allUnprocessedMentions);
            List orderedMentions = document.getOrderedMentions();
            result = this.corefSystem.coref(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

